/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package backend;

import com.pixelmed.dicom.*;

import java.io.*;
import java.util.*;
import java.lang.Integer;
/**
 *
 * @author eunyokim
 */
public class DICOMFileHandling {    
    //
    private DicomDictionary     myLocalDictionary;
    private AttributeList       listS=new AttributeList();
    private Map<String,Integer> studyHash=new HashMap<String,Integer>();
    private int                 studyHashNumber=0;
    
    //limit studyUID numbers to 10
    private String[]            orderedStudy=new String[5];    
    private String[]            studyDescription=new String[5];
    private String[]            studyDate=new String[5];
    private Map<String,Integer> seriesHash=new HashMap<String,Integer>();
    private int                 seriesHashNumber=0;
    private int[]               seriesNumberInStudy={0,0,0,0,0};
    
    private String[]            orderedSeries=new String[30];
    private String[]            seriesDescription=new String[30];
    private String[]            seriesDate=new String[30];
    private int[][]             seriesFileNumber= new int[5][30];
    private String[][][][]      orderedFile=new String[5][30][64][500];
    
    private Map<String,Integer> parameterHash=new HashMap<String,Integer>();
    private int[][]             paramHashNumber=new int[5][30];
    private int[][][]           parameterFileNumber= new int[5][30][64];    
    private Integer[][][]       flipAngle=new Integer[5][30][64];      //0018 1314
    private Integer[][][]       excitationTime=new Integer[5][30][64]; //0018 0080
    private Integer[][][]       repititionTime=new Integer[5][30][64]; //0018 0081
    
    private String[]            dicom;
    private int                 dicomNumber=0;
    //Constructor
    public DICOMFileHandling(String[] dicomFileName,int no_of_files){
        dicom=dicomFileName;
        dicomNumber=no_of_files;
        /*    
        for(int i=0;i<no_of_files;i++){
                try{
                 
                    //1. read dicom files with pixel med
                    listS.read(dicomFileName[i]);
                    //2. create dictionary
                    myLocalDictionary=listS.getDictionary();
                    //3. create finding location
                    AttributeTag at=new AttributeTag(0x0020,0x1041);
                
                    //4. get information
                        double value=Attribute.getSingleDoubleValueOrDefault(listS, at, -10.0);
                    //fileName[i]=dicomFileName[i];                
                    //Double sliceLocation=Attribute.getSingleDoubleValueOrDefault(listS, at, -1.0);
                    //String thickness=Attribute.getDelimitedStringValuesOrDefault(listS,TagFromName.SeriesInstanceUID,"N/A");
                    //5. show me!
                    //System.out.println("* File name::"+dicomFileName[i]+" * Slcie location::"+sliceLocation);
                }catch(Exception e){
                    System.out.println("fail to read ");
                }            
            }
        */
        SortbyStudyNSeries();
    }
    /*Sort Files by study name, series name, file name*/
    /**/
    public void SortbyStudyNSeries(){
        try{            
            for(int i=0;i<dicomNumber;i++){  
                Integer studyNo    = new Integer(-1);
                Integer seriesNo   = new Integer(-1);
                Integer parameterNo= new Integer(-1);
                //create hashtable          
                //Sort files grouping with series & study and sort by name
              
                //read file first
                listS.read(dicom[i]);
                //1. Find Study instance
                String studyUID=Attribute.getDelimitedStringValuesOrEmptyString(listS, TagFromName.StudyInstanceUID);
                //2. Check if there is already,                     
                //2-1 if so, have the hash value
                if(studyHash.containsKey(studyUID)){
                    //System.out.println("hit the hash with study ID::"+studyUID);
                    studyNo=new Integer(studyHash.get(studyUID).toString());
                }
                //2-2 if not make hash key(study instance ID)-value(index_study) pair
                else {
                    //studyHash.put(studyUID, studyHashNumber++);
                    studyNo=new Integer(studyHashNumber++);
                    studyHash.put(studyUID, studyNo);  
                    //System.out.println("insert Study ID-->"+studyUID);
                    InsertinOrder(studyUID,orderedStudy,studyHashNumber-2);
                    //Have study description
                    studyDescription[studyNo]=Attribute.getDelimitedStringValuesOrEmptyString(listS,TagFromName.StudyDescription);
                    studyDate[studyNo]=Attribute.getDelimitedStringValuesOrEmptyString(listS,TagFromName.StudyDate);
                }
                //3. Find Seriese Instance
                String seriesUID=Attribute.getDelimitedStringValuesOrEmptyString(listS, TagFromName.SeriesInstanceUID);
                //4. Check if it exists already in hash table
                //4-1 ifi so, have the hash value
                if(seriesHash.containsKey(seriesUID)){//case of existing       
                    //System.out.println("hit the hash with series ID::"+seriesUID);
                    seriesNo=new Integer(seriesHash.get(seriesUID).toString());
                    //eachFileNumber[studyNo.intValue()][seriesNo.intValue()]=eachFileNumber[studyNo.intValue()][seriesNo.intValue()]+1;
                }
                //4-2 if not, create hash(series ID)-value(index_series++) pair
                else{                
                    //System.out.println("not hit the hash with series ID::"+seriesUID);
                    seriesNumberInStudy[studyNo]++;                    
                    seriesNo=new Integer(seriesHashNumber++);
                    seriesDescription[seriesNo]=Attribute.getDelimitedStringValuesOrEmptyString(listS,TagFromName.SeriesDescription);
                    seriesDate[seriesNo]=Attribute.getDelimitedStringValuesOrEmptyString(listS,TagFromName.SeriesDate);
                    seriesHash.put(seriesUID,seriesNo);                
                    //System.out.println("insert series ID-->"+seriesUID);
                    InsertinOrder(seriesUID,orderedSeries,seriesHashNumber-2);
                
                }
                // scan parameters.
                
                AttributeTag flipA=new AttributeTag(0x0018,0x1314);   //have flip angle             
                AttributeTag ET=new AttributeTag(0x0018,0x0080);      //have excitation time           
                AttributeTag RT=new AttributeTag(0x0018,0x0081);      //have repitition time(echo)
                
                String param=""+Attribute.getSingleIntegerValueOrDefault(listS, flipA, -1)+" "+
                                Attribute.getSingleIntegerValueOrDefault(listS, ET, -1)+" "+
                                Attribute.getSingleIntegerValueOrDefault(listS, RT, -1);
                if(parameterHash.containsKey(param)){
                    parameterNo=new Integer(parameterHash.get(param).toString());
                    if(flipAngle[studyNo][seriesNo][parameterNo]==null){                        
                        String temp[]= param.split(" ");
                        flipAngle[studyNo][seriesNo][parameterNo]=new Integer(temp[0]);
                        excitationTime[studyNo][seriesNo][parameterNo]=new Integer(temp[1]);
                        repititionTime[studyNo][seriesNo][parameterNo]=new Integer(temp[2]);
                    }
                }
                else{
                    parameterNo=new Integer(paramHashNumber[studyNo][seriesNo]++);
                    parameterHash.put(param, parameterNo);
                    String temp[]= param.split(" ");
                    flipAngle[studyNo][seriesNo][parameterNo]=new Integer(temp[0]);
                    excitationTime[studyNo][seriesNo][parameterNo]=new Integer(temp[1]);
                    repititionTime[studyNo][seriesNo][parameterNo]=new Integer(temp[2]);
                }
                seriesFileNumber[studyNo][seriesNo]++;
                parameterFileNumber[studyNo][seriesNo][parameterNo]++;
                //5. sort files for each study & series           
                String temp[]=dicom[i].split("/");           
                //System.out.println("==>"+eachFileNumber[studyNo][seriesNo]);
                InsertinOrder(temp[temp.length-1],orderedFile[studyNo][seriesNo][parameterNo],parameterFileNumber[studyNo][seriesNo][parameterNo]-2);
                }
            }catch(Exception e){
            System.out.println("* Error in SortbyStudyNSeries::"+dicom[0]+"::"+e);
        }
    }
    /*insert module*/
    void InsertinOrder(String key,String[] target,int i){
      //insert key string to target array in order
        try{              
            //System.out.println("insert this item ("+key+")");
            if(target[0]==null){            
                target[0]=key;
                // System.out.println("insert this item ("+key+") index of 0");
            }
            else{
               while(i>-1&&CompareString(key,target[i])){
               target[i+1]=target[i];
               //System.out.println("push back this item::"+target[i+1]);
               i--;
               }                
               target[i+1]=key;
               // System.out.println("insert this item ("+key+") index of "+(i+1));                
            }
        }catch(Exception e){
            System.out.println("* Error with InsertinOrder with "+key+" :: "+e);
        }
    } 
    /*printing module*/
    public void Print_orderedResult(){
        try{  
            int a=0;        
            System.out.println("Number of Studies::"+studyHashNumber);
            System.out.println("*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*");
            while(orderedStudy[a]!=null){            
                //print out study description
                int b=0;
                System.out.println("Study::"+orderedStudy[a]);
                System.out.print("(StudyDescription:\""+studyDescription[a]);
                System.out.print("\" Study date: "+studyDate[a].substring(0, 4)+"-"+studyDate[a].substring(4, 6)+"-"+studyDate[a].substring(6));
                System.out.println(" Number of Series:"+seriesNumberInStudy[a]+")");
                Integer study=new Integer(studyHash.get(orderedStudy[a]).toString());
                while(orderedSeries[b]!=null){
                    //print out series description
                    int param=0;
                    Integer series=new Integer(seriesHash.get(orderedSeries[b]).toString());
                    System.out.println("-------Series::"+orderedSeries[b]);    
                    System.out.print("-------(SereisDescription: \""+seriesDescription[b]);
                    System.out.print("\" Series date: "+seriesDate[b].substring(0, 4)+"-"+seriesDate[b].substring(4, 6)+"-"+seriesDate[b].substring(6));
                    System.out.println(" Number of Files: "+seriesFileNumber[study][series]+")");
                    
                    while(excitationTime[study][series][param]!=null){
                        int d=0;
                        System.out.print("------------Scan Parameter: FlipAngel: "+flipAngle[study][series][param]);
                        System.out.print(" Excitation time: "+excitationTime[study][series][param]);
                        System.out.println(" Repitition time: "+repititionTime[study][series][param]);
                        while(orderedFile[study][series][param][d]!=null){
                            System.out.println("---------------------------"+orderedFile[study][series][param][d]);
                            d++;
                        }      
                        param++;
                    }
                    b++;
                }
                a++;
            } 
        }catch(Exception e){
            System.out.println("* error in Print ::"+e);
        }
    }
    /*comparing function*/
    boolean CompareString(String s1, String s2){
        //compare the file names with last few digits
        //return true if need to switch
        try{
            if(s1.endsWith("dcm")){
            
                Integer s11=new Integer(s1.substring(8,12));
                Integer s22=new Integer(s2.substring(8,12));
                //System.out.println("comparing string:::::::::::::::"+s11);
                if(s11.intValue()>s22.intValue()){
                    return false;
                }
                else return true;
            }
            else{
                Long s11=new Long(s1.substring(37));//why not for 27????
                Long s22=new Long(s2.substring(37));
                //System.out.println("Index:---------------------------::::::::"+s11);  
                if(s11.intValue()>s22.intValue())  return false;  
                else                               return true;
            }
         }catch(Exception e){
            System.out.println("* Error with CompareString::"+e);
         }
         return true;
              
    }   

}
