/*
 * Decompiled with CFR 0.152.
 */
package JSci.astro.telescope;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

public final class LX200 {
    private SerialPort serial;
    private InputStreamReader in;
    private OutputStreamWriter out;
    public static final int FOCUS_FAST = 1;
    public static final int FOCUS_SLOW = 2;
    public static final int FOCUS_IN = 1;
    public static final int FOCUS_OUT = 2;
    public static final int SLEW_SLEW = 1;
    public static final int SLEW_FIND = 2;
    public static final int SLEW_CENTER = 3;
    public static final int SLEW_GUIDE = 4;
    public static final int SLEW_NORTH = 1;
    public static final int SLEW_EAST = 2;
    public static final int SLEW_SOUTH = 3;
    public static final int SLEW_WEST = 4;

    public static float raToFloat(String string) {
        float f = Integer.valueOf(string.substring(0, 2)).floatValue();
        float f2 = Integer.valueOf(string.substring(3, 5)).floatValue();
        float f3 = Integer.valueOf(string.substring(6, 8)).floatValue();
        return f + f2 / 60.0f + f3 / 600.0f;
    }

    public static float decToFloat(String string) {
        float f = Integer.valueOf(string.substring(0, 3)).floatValue();
        float f2 = Integer.valueOf(string.substring(4, 6)).floatValue();
        float f3 = Integer.valueOf(string.substring(7, 9)).floatValue();
        if ((double)f >= 0.0) {
            return f + f2 / 60.0f + f3 / 600.0f;
        }
        return f - f2 / 60.0f - f3 / 600.0f;
    }

    public static float altToFloat(String string) {
        float f = Integer.valueOf(string.substring(0, 3)).floatValue();
        float f2 = Integer.valueOf(string.substring(4, 6)).floatValue();
        float f3 = Integer.valueOf(string.substring(7, 9)).floatValue();
        if ((double)f >= 0.0) {
            return f + f2 / 60.0f + f3 / 600.0f;
        }
        return f - f2 / 60.0f - f3 / 600.0f;
    }

    public static float azToFloat(String string) {
        float f = Integer.valueOf(string.substring(0, 3)).floatValue();
        float f2 = Integer.valueOf(string.substring(4, 6)).floatValue();
        float f3 = Integer.valueOf(string.substring(7, 9)).floatValue();
        return f + f2 / 60.0f + f3 / 600.0f;
    }

    public LX200(String string) {
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
            this.serial = (SerialPort)commPortIdentifier.open("LX200", 10);
            this.serial.setSerialPortParams(9600, 8, 1, 0);
            this.in = new InputStreamReader(this.serial.getInputStream());
            this.out = new OutputStreamWriter(this.serial.getOutputStream());
            this.setHighPrecision(true);
            this.setLongFormat(true);
        }
        catch (NoSuchPortException noSuchPortException) {
            System.err.println("Port does not exist: " + noSuchPortException.getMessage());
            noSuchPortException.printStackTrace();
        }
        catch (PortInUseException portInUseException) {
            System.err.println("Port is in use by another process: " + portInUseException.getMessage());
            portInUseException.printStackTrace();
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void setHighPrecision(boolean bl) throws IOException {
        boolean bl2 = this.toggleHighPrecision();
        if (bl != bl2) {
            this.toggleHighPrecision();
        }
    }

    private boolean toggleHighPrecision() throws IOException {
        char[] cArray = new char[14];
        this.sendCmd("#:P#");
        this.in.read(cArray, 0, 14);
        return cArray[0] == 'H';
    }

    public synchronized void setLongFormat(boolean bl) throws IOException {
        boolean bl2 = this.isLongFormatEnabled();
        if (bl != bl2) {
            this.sendCmd("#:U#");
        }
    }

    private boolean isLongFormatEnabled() throws IOException {
        this.sendCmd("#:GR#");
        String string = this.readString();
        return string.length() == 9;
    }

    public synchronized void setFocusRate(int n) throws IOException {
        switch (n) {
            case 1: {
                this.sendCmd("#:FF#");
                break;
            }
            case 2: {
                this.sendCmd("#:FS#");
            }
        }
    }

    public synchronized void startFocus(int n) throws IOException {
        switch (n) {
            case 1: {
                this.sendCmd("#:F+#");
                break;
            }
            case 2: {
                this.sendCmd("#:F-#");
            }
        }
    }

    public synchronized void stopFocus() throws IOException {
        this.sendCmd("#:FQ#");
    }

    public synchronized void setSlewRate(int n) throws IOException {
        switch (n) {
            case 1: {
                this.sendCmd("#:RS#");
                break;
            }
            case 2: {
                this.sendCmd("#:RM#");
                break;
            }
            case 3: {
                this.sendCmd("#:RC#");
                break;
            }
            case 4: {
                this.sendCmd("#:RG#");
            }
        }
    }

    public synchronized void startSlew(int n) throws IOException {
        switch (n) {
            case 1: {
                this.sendCmd("#:Mn#");
                break;
            }
            case 2: {
                this.sendCmd("#:Me#");
                break;
            }
            case 3: {
                this.sendCmd("#:Ms#");
                break;
            }
            case 4: {
                this.sendCmd("#:Mw#");
            }
        }
    }

    public synchronized void stopSlew(int n) throws IOException {
        switch (n) {
            case 1: {
                this.sendCmd("#:Qn#");
                break;
            }
            case 2: {
                this.sendCmd("#:Qe#");
                break;
            }
            case 3: {
                this.sendCmd("#:Qs#");
                break;
            }
            case 4: {
                this.sendCmd("#:Qw#");
            }
        }
    }

    public synchronized String getRA() throws IOException {
        this.sendCmd("#:GR#");
        return this.readString();
    }

    public synchronized String getDec() throws IOException {
        this.sendCmd("#:GD#");
        return this.readString();
    }

    public synchronized String getAlt() throws IOException {
        this.sendCmd("#:GA#");
        return this.readString();
    }

    public synchronized String getAz() throws IOException {
        this.sendCmd("#:GZ#");
        return this.readString();
    }

    public synchronized boolean setObjectCoords(String string, String string2) throws IOException {
        this.sendCmd("#:Sr" + string + "#");
        boolean bl = this.readBoolean();
        this.sendCmd("#:Sd" + string2 + "#");
        return bl &= this.readBoolean();
    }

    public synchronized int slewToObject() throws IOException {
        this.sendCmd("#:MS#");
        int n = this.in.read();
        if (n == 48) {
            return 0;
        }
        if (n == 49) {
            this.readString();
            return 1;
        }
        if (n == 50) {
            this.readString();
            return 2;
        }
        return -1;
    }

    public synchronized boolean checkPosition(float f, float f2) throws IOException {
        float f3 = LX200.raToFloat(this.getRA()) - f;
        float f4 = LX200.decToFloat(this.getDec()) - f2;
        return (double)Math.abs(f3) <= 0.0022222222222222222 && (double)Math.abs(f4) <= 0.03333333333333333;
    }

    public synchronized boolean isMoving() throws IOException {
        String string = this.getRA();
        String string2 = this.getDec();
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String string3 = this.getRA();
        String string4 = this.getDec();
        return !string3.equals(string) || !string4.equals(string2);
    }

    public synchronized String getLocalTime() throws IOException {
        this.sendCmd("#:GL#");
        return this.readString();
    }

    public synchronized boolean setLocalTime(String string) throws IOException {
        this.sendCmd("#:SL" + string + "#");
        return this.readBoolean();
    }

    public synchronized void syncCoords() throws IOException {
        this.sendCmd("#:CM#");
        this.readString();
    }

    private void sendCmd(String string) throws IOException {
        this.out.write(string);
        this.out.flush();
    }

    private boolean readBoolean() throws IOException {
        return this.in.read() == 49;
    }

    private String readString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.in.read();
        while (n != 35) {
            stringBuffer.append(n);
            n = this.in.read();
        }
        return stringBuffer.toString();
    }

    public synchronized void close() throws IOException {
        this.in.close();
        this.out.close();
        this.serial.close();
    }
}

