/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Image;
import JSci.instruments.ImageFilterAdapter;
import JSci.instruments.ImageSink;
import JSci.instruments.ImageSource;
import JSci.instruments.PTTwoDBarycentreCross;
import JSci.instruments.ParticleTracker;
import JSci.instruments.ParticleTrackerListener;
import JSci.instruments.Player;
import JSci.instruments.ROI;
import JSci.instruments.RectangularROI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PTTwoDBarycentre
extends ImageFilterAdapter
implements ParticleTracker {
    public static boolean INTERLACED = true;
    public static int TIME_FIELD = 20;
    private JComboBox crossCombo = new JComboBox();
    private static long startTime = System.currentTimeMillis();
    private ParticleTrackerListener ptl = null;
    JComponent comp;
    private ROI theROI = null;

    public String getName() {
        return "PT TwoD Barycentre";
    }

    public void setListener(ParticleTrackerListener particleTrackerListener) {
        this.ptl = particleTrackerListener;
    }

    public String toString() {
        return "Particle Tracking; INTERLACED=" + INTERLACED + "; ALPHA=" + PTTwoDBarycentreCross.ALPHA + "; WEIGHT_LIGHT_PART=" + PTTwoDBarycentreCross.WEIGHT_LIGHT_PART + "; REGION_SPEED=" + PTTwoDBarycentreCross.REGION_SPEED + "; ODD_EVEN=" + PTTwoDBarycentreCross.ODD_EVEN + "; startTime=" + startTime;
    }

    public void filter(Image image) {
        PTTwoDBarycentreCross pTTwoDBarycentreCross;
        int n;
        ComboBoxModel comboBoxModel = this.crossCombo.getModel();
        if (comboBoxModel.getSize() == 0) {
            return;
        }
        int[] nArray = new int[comboBoxModel.getSize()];
        double[] dArray = new double[comboBoxModel.getSize()];
        double[] dArray2 = new double[comboBoxModel.getSize()];
        for (n = 0; n < comboBoxModel.getSize(); ++n) {
            pTTwoDBarycentreCross = (PTTwoDBarycentreCross)comboBoxModel.getElementAt(n);
            if (INTERLACED) {
                pTTwoDBarycentreCross.findInterlaced(image);
            } else {
                pTTwoDBarycentreCross.find(image);
            }
            nArray[n] = pTTwoDBarycentreCross.getN();
            dArray[n] = pTTwoDBarycentreCross.getX();
            dArray2[n] = pTTwoDBarycentreCross.getY();
        }
        if (this.ptl != null) {
            this.ptl.receivePosition(image.getTimeStamp() - startTime, nArray, dArray, dArray2, null);
        }
        if (!INTERLACED) {
            return;
        }
        for (n = 0; n < comboBoxModel.getSize(); ++n) {
            pTTwoDBarycentreCross = (PTTwoDBarycentreCross)comboBoxModel.getElementAt(n);
            dArray[n] = pTTwoDBarycentreCross.getX2();
            dArray2[n] = pTTwoDBarycentreCross.getY2();
        }
        if (this.ptl != null) {
            this.ptl.receivePosition(image.getTimeStamp() + (long)TIME_FIELD - startTime, nArray, dArray, dArray2, null);
        }
    }

    public Component getFilterControlComponent() {
        if (this.comp != null) {
            return this.comp;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JButton jButton = new JButton("Add");
        jPanel.add("North", jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PTTwoDBarycentre.this.theROI == null) {
                    return;
                }
                PTTwoDBarycentreCross pTTwoDBarycentreCross = new PTTwoDBarycentreCross((Rectangle)PTTwoDBarycentre.this.theROI.getShape());
                PTTwoDBarycentre.this.crossCombo.addItem(pTTwoDBarycentreCross);
            }
        });
        JButton jButton2 = new JButton("Remove");
        jPanel.add("South", jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PTTwoDBarycentre.this.crossCombo.removeItem(PTTwoDBarycentre.this.crossCombo.getSelectedItem());
            }
        });
        this.crossCombo.setEditable(false);
        jPanel.add("East", this.crossCombo);
        return jPanel;
    }

    public void setROI(ROI rOI) {
        this.theROI = rOI;
    }

    public static void main(String[] stringArray) {
        RectangularROI rectangularROI = new RectangularROI(10, 10, 30, 30);
        PTTwoDBarycentre pTTwoDBarycentre = new PTTwoDBarycentre();
        Player player = new Player();
        SimulatedBarycentreSource simulatedBarycentreSource = new SimulatedBarycentreSource();
        simulatedBarycentreSource.setSink(pTTwoDBarycentre);
        pTTwoDBarycentre.setSink(player);
        player.addROI(rectangularROI);
        pTTwoDBarycentre.setROI(rectangularROI);
        player.start();
        final NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(4);
        ParticleTrackerListener particleTrackerListener = new ParticleTrackerListener(){

            public void receivePosition(long l, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3) {
                System.out.print(l);
                for (int i = 0; i < nArray.length; ++i) {
                    System.out.print(" " + nArray[i] + " " + numberFormat.format(dArray[i]) + " " + numberFormat.format(dArray2[i]));
                }
                System.out.println();
            }
        };
        pTTwoDBarycentre.setListener(particleTrackerListener);
    }

    static class SimulatedBarycentreSource
    implements ImageSource,
    Runnable {
        Dimension dim = new Dimension(130, 97);
        private ImageSink sink;
        private static final double SIGMA = 4.0;
        private static final double DELTAX = 4.0;
        private static final double DELTAY = 2.0;

        public SimulatedBarycentreSource() {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
        }

        public void setSink(ImageSink imageSink) {
            if (this.sink != imageSink) {
                this.sink = imageSink;
                this.sink.setSource(this);
            }
        }

        private double f(double d, double d2) {
            return Math.exp(-(d * d + d2 * d2) / 32.0) - Math.exp(-((d - 4.0) * (d - 4.0) + (d2 - 2.0) * (d2 - 2.0)) / 32.0);
        }

        public void run() {
            int n = 0;
            while (true) {
                int n2 = n++;
                final long l = System.currentTimeMillis();
                double d = Math.random() * 4.0 + 40.0;
                double d2 = Math.random() * 4.0 + 50.0;
                final byte[] byArray = new byte[this.getWidth() * this.getHeight()];
                final Dimension dimension = new Dimension(this.getWidth(), this.getHeight());
                Image image = new Image(){

                    public byte[] getData() {
                        return byArray;
                    }

                    public Dimension getSize() {
                        return dimension;
                    }

                    public long getTimeStamp() {
                        return l;
                    }
                };
                for (int i = 0; i < image.getWidth(); ++i) {
                    for (int j = 0; j < image.getHeight(); ++j) {
                        image.getData()[i + j * image.getWidth()] = (byte)(128.0 + 128.0 * this.f((double)i - d, (double)j - d2));
                    }
                }
                if (this.sink != null) {
                    this.sink.receive(image);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public int getWidth() {
            return this.dim.width;
        }

        public int getHeight() {
            return this.dim.height;
        }

        public Dimension getSize() {
            return this.dim;
        }

        public Component getControlComponent() {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Test"));
            Border border = BorderFactory.createEtchedBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "source");
            jPanel.setBorder(titledBorder);
            return jPanel;
        }
    }
}

