/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Image;
import JSci.instruments.ImageSink;
import JSci.instruments.ImageSource;
import JSci.instruments.ROI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.image.MemoryImageSource;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class Player
extends JPanel
implements ImageSink {
    private MemoryImageSource imgsource = null;
    private java.awt.Image img = null;
    private Image currentImage = null;
    private ImageSource source = null;
    private int decimationFrame = 0;
    private int decimationNumber = 1;
    private long receivedFrames = 0L;
    private long displayedFrames = 0L;
    private long lastReceivedFrames = 0L;
    private long lastDisplayedFrames = 0L;
    private long last = System.currentTimeMillis();
    private JLabel receivedFramesLabel;
    private JLabel displayedFramesLabel;
    private boolean newImagePresent = false;
    private static NumberFormat formatter = NumberFormat.getNumberInstance();
    ROI r;

    public Player() {
        formatter.setMaximumFractionDigits(1);
        formatter.setMinimumFractionDigits(1);
        formatter.setMinimumIntegerDigits(1);
        formatter.setMaximumIntegerDigits(3);
        this.r = null;
    }

    public void setSource(ImageSource imageSource) {
        if (this.source != imageSource) {
            this.source = imageSource;
            this.source.setSink(this);
        }
    }

    public void setDecimationNumber(int n) {
        this.decimationNumber = n;
    }

    public void runStatisticsUpdate() {
        while (true) {
            long l = this.receivedFrames;
            long l2 = this.displayedFrames;
            long l3 = System.currentTimeMillis();
            this.receivedFramesLabel.setText("received: " + formatter.format((double)(this.lastReceivedFrames - l) * 1000.0 / (double)(this.last - l3)) + " Hz");
            this.displayedFramesLabel.setText("displayed: " + formatter.format((double)(this.lastDisplayedFrames - l2) * 1000.0 / (double)(this.last - l3)) + " Hz");
            this.lastReceivedFrames = l;
            this.lastDisplayedFrames = l2;
            this.last = l3;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void receive(Image image) {
        ++this.receivedFrames;
        this.currentImage = image;
        ++this.decimationFrame;
        if (this.decimationFrame == this.decimationNumber) {
            this.decimationFrame = 0;
        }
        if (this.imgsource == null) {
            this.setSize(image.getSize());
            this.imgsource = new MemoryImageSource(image.getWidth(), image.getHeight(), image.getColorModel(), image.getData(), image.getOffset(), image.getScansize());
            this.imgsource.setAnimated(true);
            this.img = this.createImage(this.imgsource);
        } else if (this.decimationFrame == 0) {
            this.imgsource.newPixels(image.getData(), image.getColorModel(), image.getOffset(), image.getScansize());
            this.newImagePresent = true;
        }
    }

    public void start() {
        while (this.imgsource == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        JFrame jFrame = new JFrame("Player");
        jFrame.setSize(this.getSize().width + 10, this.getSize().height + 30);
        jFrame.getContentPane().add(this);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
        JFrame jFrame2 = new JFrame("Controls");
        jFrame2.getContentPane().add(this.getControlComponent());
        jFrame2.pack();
        jFrame2.setDefaultCloseOperation(3);
        jFrame2.setVisible(true);
    }

    public void addROI(ROI rOI) {
        this.r = rOI;
        rOI.setComponent(this);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.img != null) {
            graphics.drawImage(this.img, 0, 0, this);
        }
        if (this.newImagePresent) {
            ++this.displayedFrames;
            this.newImagePresent = false;
        }
        if (this.currentImage != null) {
            this.currentImage.doOverlay(graphics);
        }
        if (this.r != null) {
            this.r.paint(graphics);
        }
    }

    public Component getControlComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        if (this.source.getControlComponent() != null) {
            jPanel.add(this.source.getControlComponent());
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.receivedFramesLabel = new JLabel("received: 000.0 Hz");
        this.displayedFramesLabel = new JLabel("displayed: 000.0 Hz");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Player.this.runStatisticsUpdate();
            }
        });
        thread.setDaemon(true);
        thread.start();
        jPanel2.add("North", this.receivedFramesLabel);
        jPanel2.add("South", this.displayedFramesLabel);
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "player");
        jPanel2.setBorder(titledBorder);
        jPanel.add(jPanel2);
        return jPanel;
    }
}

