/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.DoubleBufferedCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public final class ContourPlot
extends DoubleBufferedCanvas {
    private float[][] data;
    private double min;
    private double max;
    private int deltay;
    private int[] deltax;
    private float c1 = 1.0f;
    private float c2 = 1.0f;
    private float c3 = 1.0f;
    private int Contourx = 1;
    private int Contoury = 1;
    private int largeurMax;
    private int hauteurMax;

    public ContourPlot(double[][] dArray) {
        this.setBackground(Color.white);
        this.setData(dArray);
        this.setContourX(1);
        this.setContourY(1);
    }

    public void setData(double[][] dArray) {
        int n;
        int n2;
        double[][] dArrayArray = new double[dArray.length][];
        for (n2 = 0; n2 < dArrayArray.length; ++n2) {
            dArrayArray[n2] = dArray[dArrayArray.length - n2 - 1];
        }
        this.min = dArrayArray[0][0];
        this.max = dArrayArray[0][0];
        this.data = new float[dArrayArray.length][];
        for (n2 = 0; n2 < dArrayArray.length; ++n2) {
            this.data[n2] = new float[dArrayArray[n2].length];
            for (n = 0; n < dArrayArray[n2].length; ++n) {
                if (dArrayArray[n2][n] > this.max) {
                    this.max = dArrayArray[n2][n];
                }
                if (!(dArrayArray[n2][n] < this.min)) continue;
                this.min = dArrayArray[n2][n];
            }
        }
        if (this.max == this.min) {
            for (n2 = 0; n2 < dArrayArray.length; ++n2) {
                for (n = 0; n < dArrayArray[n2].length; ++n) {
                    this.data[n2][n] = 1.0f;
                }
            }
        } else {
            for (n = 0; n < dArrayArray.length; ++n) {
                for (int i = 0; i < dArrayArray[n].length; ++i) {
                    Double d = new Double(1.0 - (dArrayArray[n][i] - this.min) / (this.max - this.min));
                    this.data[n][i] = d.floatValue();
                }
            }
        }
        this.rescale();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int n = this.data[0].length;
        for (int i = 1; i < this.data.length; ++i) {
            if (this.data[i].length <= n) continue;
            n = this.data[i].length;
        }
        return new Dimension(n + 2 * this.Contourx, this.data.length + 2 * this.Contoury);
    }

    public void setContourX(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("This parameter must be greater than 1 : " + n + " < 1");
        }
        this.Contourx = n;
    }

    public void setContourY(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("This parameter must be greater than 1 : " + n + " < 1");
        }
        this.Contoury = n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    private void rescale() {
        Dimension dimension = this.getSize();
        int n = dimension.width - 2 * this.Contourx;
        int n2 = dimension.height - 2 * this.Contoury;
        this.deltay = (int)Math.floor(n2 / this.data.length);
        this.hauteurMax = this.deltay * this.data.length;
        this.deltax = new int[this.data.length];
        this.largeurMax = 0;
        for (int i = 0; i < this.data.length; ++i) {
            this.deltax[i] = (int)Math.floor(n / this.data[i].length);
            if (this.data[i].length * this.deltax[i] <= this.largeurMax) continue;
            this.largeurMax = this.data[i].length * this.deltax[i];
        }
        this.redraw();
    }

    public void setColor(float f, float f2, float f3) {
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f) {
            throw new IllegalArgumentException("Incorrect parameters : " + f + ", " + f2 + ", " + f3);
        }
        if (f + f2 + f3 == 0.0f) {
            throw new IllegalArgumentException("You have chosen black at the specified color. This would generate a completly black graph. Please choose another color.");
        }
        this.c1 = f;
        this.c2 = f2;
        this.c3 = f3;
    }

    protected void offscreenPaint(Graphics graphics) {
        graphics.setColor(new Color(1.0f - this.c1, 1.0f - this.c2, 1.0f - this.c3));
        graphics.drawRect(this.Contourx - 1, this.Contoury - 1, this.largeurMax, this.hauteurMax);
        graphics.setClip(this.Contourx, this.Contoury, this.largeurMax - 1, this.hauteurMax - 1);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[i].length; ++j) {
                graphics.setColor(Color.getHSBColor(this.data[i][j], 1.0f, 1.0f));
                graphics.fillRect(j * this.deltax[i] + this.Contourx, i * this.deltay + this.Contoury, (j + 1) * this.deltax[i] + this.Contourx, (i + 1) * this.deltay + this.Contoury);
            }
        }
    }
}

