/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.CategoryGraph2DModel;
import JSci.awt.GraphDataEvent;
import JSci.maths.ExtraMath;
import JSci.swing.JCategoryGraph2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class JBarGraph
extends JCategoryGraph2D {
    protected Color[] barColor = new Color[]{Color.blue, Color.green, Color.red, Color.yellow, Color.cyan, Color.lightGray, Color.magenta, Color.orange, Color.pink};
    protected float minY;
    protected float maxY;
    private final float yIncPixels = 40.0f;
    private float yInc;
    private boolean autoYInc = true;
    private float xScale;
    private float yScale;
    protected int barWidth;
    protected final int barPad = 0;
    protected boolean numbering = true;
    protected NumberFormat yNumberFormat = new DecimalFormat("##0.0");

    public JBarGraph(CategoryGraph2DModel categoryGraph2DModel) {
        super(categoryGraph2DModel);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public void dataChanged(GraphDataEvent graphDataEvent) {
        this.minY = 0.0f;
        this.maxY = Float.NEGATIVE_INFINITY;
        this.model.firstSeries();
        do {
            for (int i = 0; i < this.model.seriesLength(); ++i) {
                float f = this.model.getValue(i);
                this.minY = Math.min(f, this.minY);
                this.maxY = Math.max(f, this.maxY);
            }
        } while (this.model.nextSeries());
        if (this.minY == this.maxY) {
            this.minY -= 0.5f;
            this.maxY += 0.5f;
        }
        this.setNumbering(this.numbering);
    }

    public final void setColor(int n, Color color) {
        this.barColor[n] = color;
        this.redraw();
    }

    public final Color getColor(int n) {
        return this.barColor[n];
    }

    public final void setNumbering(boolean bl) {
        this.numbering = bl;
        this.leftAxisPad = 25;
        if (this.numbering && this.getFont() != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth(this.yNumberFormat.format(this.maxY));
            int n2 = fontMetrics.stringWidth(this.yNumberFormat.format(this.minY));
            int n3 = Math.max(n2, n);
            this.leftAxisPad += n3;
        }
        this.rescale();
    }

    public void addNotify() {
        super.addNotify();
        this.setNumbering(this.numbering);
    }

    public final void setNumberFormat(NumberFormat numberFormat) {
        this.yNumberFormat = numberFormat;
        this.setNumbering(this.numbering);
    }

    public final void setYNumberFormat(NumberFormat numberFormat) {
        this.yNumberFormat = numberFormat;
        this.setNumbering(this.numbering);
    }

    public final void setYIncrement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Increment should be positive.");
        }
        if (f == 0.0f) {
            if (!this.autoYInc) {
                this.autoYInc = true;
                this.rescale();
            }
        } else {
            this.autoYInc = false;
            if (f != this.yInc) {
                this.yInc = f;
                this.rescale();
            }
        }
    }

    public final float getYIncrement() {
        return this.yInc;
    }

    public final float getYMinimum() {
        return this.minY;
    }

    public final float getYMaximum() {
        return this.maxY;
    }

    protected final void drawAxes(Graphics graphics) {
        graphics.setColor(this.getForeground());
        if (this.minY > 0.0f) {
            graphics.drawLine(this.leftAxisPad - 5, this.getHeight() - 25, this.getWidth() - 20, this.getHeight() - 25);
        } else {
            graphics.drawLine(this.leftAxisPad - 5, this.origin.y, this.getWidth() - 20, this.origin.y);
        }
        graphics.drawLine(this.origin.x, 20, this.origin.x, this.getHeight() - 20);
        for (int i = 0; i < this.model.seriesLength(); ++i) {
            this.drawXLabel(graphics, i);
        }
        if (this.numbering) {
            double d;
            for (d = (double)this.yInc; d <= (double)this.maxY; d += (double)this.yInc) {
                this.drawYLabel(graphics, (float)d);
            }
            for (d = (double)(-this.yInc); d >= (double)this.minY; d -= (double)this.yInc) {
                this.drawYLabel(graphics, (float)d);
            }
        }
    }

    protected void drawXLabel(Graphics graphics, int n) {
        boolean bl;
        Point point = this.dataToScreen((float)n + 1.0f, 0.0f);
        String string = this.model.getCategory(n);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.getHeight();
        boolean bl2 = bl = this.maxY <= 0.0f;
        if (bl) {
            graphics.drawLine(point.x, point.y, point.x, point.y - 5);
            graphics.drawString(string, this.dataToScreen((float)((float)n + 0.5f - 0.5f * (float)n2 / this.xScale), (float)0.0f).x, this.origin.y - 5);
        } else {
            graphics.drawLine(point.x, point.y, point.x, point.y + 5);
            graphics.drawString(string, this.dataToScreen((float)((float)n + 0.5f - 0.5f * (float)n2 / this.xScale), (float)0.0f).x, this.origin.y + n3);
        }
    }

    protected void drawYLabel(Graphics graphics, float f) {
        Point point = this.dataToScreen(0.0f, f);
        String string = this.yNumberFormat.format(f);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawLine(point.x, point.y, point.x - 5, point.y);
        graphics.drawString(string, point.x - 8 - n, point.y + n2 / 3);
    }

    protected void drawBars(Graphics graphics) {
        int n = 1;
        this.model.firstSeries();
        while (this.model.nextSeries()) {
            ++n;
        }
        if (n == 1) {
            for (int i = 0; i < this.model.seriesLength(); ++i) {
                this.drawBar(graphics, i, this.model.getValue(i), this.barColor[0], this.barWidth, 0);
            }
        } else {
            float f = (float)this.barWidth / (float)n;
            int n2 = Math.round(f);
            for (int i = 0; i < this.model.seriesLength(); ++i) {
                this.model.firstSeries();
                for (int j = 0; j < n; ++j) {
                    this.drawBar(graphics, i, this.model.getValue(i), this.barColor[j], n2, Math.round((float)j * f));
                    this.model.nextSeries();
                }
            }
        }
    }

    private void drawBar(Graphics graphics, int n, float f, Color color, int n2, int n3) {
        Point point = this.dataToScreen(n, f);
        int n4 = f < 0.0f ? this.origin.y : point.y;
        int n5 = Math.abs(point.y - this.origin.y);
        graphics.setColor(color);
        graphics.fillRect(point.x + 0 + n3, n4, n2, n5);
        graphics.setColor(Color.black);
        graphics.drawRect(point.x + 0 + n3, n4, n2, n5);
    }

    protected void offscreenPaint(Graphics graphics) {
        this.drawBars(graphics);
        this.drawAxes(graphics);
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    protected final void rescale() {
        Dimension dimension = this.getMinimumSize();
        int n = Math.max(this.getWidth(), dimension.width);
        int n2 = Math.max(this.getHeight(), dimension.height);
        this.xScale = (float)(n - (this.leftAxisPad + 25)) / (float)this.model.seriesLength();
        float f = this.minY > 0.0f ? this.maxY : ((double)this.maxY < 0.0 ? -this.minY : this.maxY - this.minY);
        this.yScale = (float)((double)(n2 - 50) / (double)f);
        if (this.autoYInc) {
            this.yInc = (float)ExtraMath.round((double)(40.0 / (double)this.yScale), (int)1);
            if (this.yInc == 0.0f) {
                this.yInc = Float.MIN_VALUE;
            }
        }
        this.barWidth = Math.round(this.xScale - 0.0f);
        this.origin.x = this.leftAxisPad;
        this.origin.y = n2 - 25 + Math.round(this.minY * this.yScale);
        this.redraw();
    }

    protected final Point dataToScreen(float f, float f2) {
        return new Point(this.origin.x + Math.round(this.xScale * f), this.origin.y - Math.round(this.yScale * f2));
    }

    protected final Point2D.Float screenToData(Point point) {
        double d = (double)(point.x - this.origin.x) / (double)this.xScale;
        double d2 = (double)(this.origin.y - point.y) / (double)this.yScale;
        return new Point2D.Float((float)d, (float)d2);
    }
}

