/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.ColorScheme;
import JSci.swing.JDoubleBufferedComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public final class JContourPlot
extends JDoubleBufferedComponent
implements ColorScheme {
    private float[][] data;
    private double min;
    private double max;
    private int deltay;
    private ColorScheme CS = this;
    private double[] deltax;
    private float c1 = 1.0f;
    private float c2 = 1.0f;
    private float c3 = 1.0f;
    private int Contourx = 2;
    private int Contoury = 2;
    private int largeurMax;
    private int hauteurMax;
    private int ColorScaleWidth = 40;
    private String MaxString;
    private String MinString;
    private String MiddleString;

    public JContourPlot(double[][] dArray) {
        this.setBackground(Color.white);
        this.setData(dArray);
        this.setContourX(1);
        this.setContourY(1);
    }

    public void setData(double[][] dArray) {
        int n;
        int n2;
        double[][] dArrayArray = new double[dArray.length][];
        for (n2 = 0; n2 < dArrayArray.length; ++n2) {
            dArrayArray[n2] = dArray[dArrayArray.length - n2 - 1];
        }
        this.min = dArrayArray[0][0];
        this.max = dArrayArray[0][0];
        this.data = new float[dArrayArray.length][];
        for (n2 = 0; n2 < dArrayArray.length; ++n2) {
            this.data[n2] = new float[dArrayArray[n2].length];
            for (n = 0; n < dArrayArray[n2].length; ++n) {
                if (dArrayArray[n2][n] > this.max) {
                    this.max = dArrayArray[n2][n];
                }
                if (!(dArrayArray[n2][n] < this.min)) continue;
                this.min = dArrayArray[n2][n];
            }
        }
        if (this.max == this.min) {
            for (n2 = 0; n2 < dArrayArray.length; ++n2) {
                for (n = 0; n < dArrayArray[n2].length; ++n) {
                    this.data[n2][n] = 1.0f;
                }
            }
        } else {
            for (n = 0; n < dArrayArray.length; ++n) {
                for (int i = 0; i < dArrayArray[n].length; ++i) {
                    Double d = new Double(1.0 - (dArrayArray[n][i] - this.min) / (this.max - this.min));
                    this.data[n][i] = d.floatValue();
                }
            }
        }
        n2 = this.getPrecision(this.max - this.min);
        this.MaxString = Double.toString(this.round(this.max, n2));
        this.MinString = Double.toString(this.round(this.min, n2));
        this.MiddleString = Double.toString(this.round((this.max + this.min) / 2.0, n2));
        this.rescale();
    }

    private int getPrecision(double d) {
        d = Math.abs(d);
        int n = 0;
        double d2 = 1.0;
        if (d < 1.0) {
            while (d2 > d) {
                d2 /= 10.0;
                --n;
            }
            return n;
        }
        while (d2 < d) {
            d2 *= 10.0;
            ++n;
        }
        return n;
    }

    private double round(double d, int n) {
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = d / Math.abs(d);
        d = Math.abs(d);
        if (n < 0) {
            int n2 = n;
            while (n2 < 0) {
                ++n2;
                d *= 10.0;
            }
            d = Math.round(d);
            while (n < 0) {
                ++n;
                d /= 10.0;
            }
            return d * d2;
        }
        int n3 = n;
        while (n3 < 0) {
            ++n3;
            d /= 10.0;
        }
        d = Math.round(d);
        while (n < 0) {
            ++n;
            d *= 10.0;
        }
        return d * d2;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int n = this.data[0].length;
        for (int i = 1; i < this.data.length; ++i) {
            if (this.data[i].length <= n) continue;
            n = this.data[i].length;
        }
        return new Dimension(n + 3 * this.Contourx + this.ColorScaleWidth + 5, Math.max(this.data.length * 2 + 2 * this.Contoury, 100));
    }

    public void setContourX(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("This parameter must be greater than 1 : " + n + " < 1");
        }
        this.Contourx = n;
    }

    public void setContourY(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("This parameter must be greater than 1 : " + n + " < 1");
        }
        this.Contoury = n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    private void rescale() {
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        Dimension dimension = this.getMinimumSize();
        n2 = Math.max(n2, dimension.width);
        n3 = Math.max(n3, dimension.height);
        int n4 = n2 - 3 * this.Contourx;
        int n5 = n3 - 2 * this.Contoury - this.ColorScaleWidth;
        this.deltay = (int)Math.floor(n5 / this.data.length);
        this.hauteurMax = this.deltay * this.data.length;
        this.deltax = new double[this.data.length];
        this.largeurMax = 0;
        int n6 = this.data[0].length;
        for (n = 1; n < this.data.length; ++n) {
            n6 = Math.max(this.data[n].length, n6);
        }
        n = (int)Math.floor((double)n4 / (double)n6) * n6;
        for (int i = 0; i < this.data.length; ++i) {
            this.deltax[i] = (double)n / (double)this.data[i].length;
            this.largeurMax = Math.max(this.largeurMax, (int)Math.floor((double)this.data[i].length * this.deltax[i]));
        }
        this.redraw();
    }

    public void setColor(float f, float f2, float f3) {
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f) {
            throw new IllegalArgumentException("Incorrect parameters : " + f + ", " + f2 + ", " + f3);
        }
        if (f + f2 + f3 == 0.0f) {
            throw new IllegalArgumentException("You have chosen black at the specified color. This would generate a completly black graph. Please choose another color.");
        }
        this.c1 = f;
        this.c2 = f2;
        this.c3 = f3;
    }

    public Color getColor(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Color are given for values between 0 and 1 : " + f);
        }
        return Color.getHSBColor(f, 1.0f, 1.0f);
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.CS = colorScheme;
    }

    protected void offscreenPaint(Graphics graphics) {
        int n = graphics.getFontMetrics(graphics.getFont()).getHeight();
        graphics.setColor(new Color(1.0f - this.c1, 1.0f - this.c2, 1.0f - this.c3));
        graphics.drawRect(this.Contourx + this.ColorScaleWidth, this.Contoury - 1, this.largeurMax, this.hauteurMax);
        graphics.drawRect(this.Contourx - 1, this.Contoury - 1, this.ColorScaleWidth, this.hauteurMax);
        graphics.setClip(this.Contourx, this.Contoury, this.ColorScaleWidth - 1, this.hauteurMax - 1);
        for (float f = 0.0f; f < (float)this.hauteurMax; f += (float)this.hauteurMax / 255.0f) {
            graphics.setColor(this.CS.getColor(f / (float)this.hauteurMax));
            graphics.fillRect(this.Contourx, this.Contoury + (int)Math.floor(f), this.ColorScaleWidth - 1, 2);
        }
        graphics.setColor(Color.black);
        graphics.drawString(this.MaxString, this.Contourx, n + this.Contoury);
        graphics.drawString(this.MiddleString, this.Contourx, this.Contoury + (int)Math.round((double)(this.hauteurMax + n) / 2.0));
        graphics.drawString(this.MinString, this.Contourx, this.hauteurMax - 1);
        graphics.setClip(2 * this.Contourx + this.ColorScaleWidth, this.Contoury, this.largeurMax - 1, this.hauteurMax - 1);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[i].length; ++j) {
                graphics.setColor(this.CS.getColor(this.data[i][j]));
                graphics.fillRect((int)Math.floor((double)j * this.deltax[i]) + 2 * this.Contourx + this.ColorScaleWidth, i * this.deltay + this.Contoury, (int)Math.floor(((double)j + 1.0) * this.deltax[i]) + this.Contourx, (i + 1) * this.deltay + this.Contoury);
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect((int)Math.floor((double)this.data[i].length * this.deltax[i]) + 2 * this.Contourx + this.ColorScaleWidth, i * this.deltay + this.Contoury, this.largeurMax - 1, (i + 1) * this.deltay + this.Contoury);
        }
    }
}

