/*
 * Decompiled with CFR 0.152.
 */
package JSci.util;

import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.Mapping;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.ComplexDiagonalMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.ComplexTridiagonalMatrix;
import JSci.maths.matrices.DoubleDiagonalMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.DoubleTridiagonalMatrix;
import JSci.util.RandomMap;

public final class MatrixToolkit {
    private MatrixToolkit() {
    }

    public static DoubleSquareMatrix randomSquareMatrix(int n) {
        return (DoubleSquareMatrix)new DoubleSquareMatrix(n).mapElements((Mapping)RandomMap.MAP);
    }

    public static DoubleTridiagonalMatrix randomTridiagonalMatrix(int n) {
        return new DoubleTridiagonalMatrix(MatrixToolkit.toArray((AbstractDoubleMatrix)MatrixToolkit.randomSquareMatrix(n)));
    }

    public static DoubleDiagonalMatrix randomDiagonalMatrix(int n) {
        return new DoubleDiagonalMatrix(MatrixToolkit.toArray((AbstractDoubleMatrix)MatrixToolkit.randomSquareMatrix(n)));
    }

    public static ComplexSquareMatrix randomComplexSquareMatrix(int n) {
        return (ComplexSquareMatrix)new ComplexSquareMatrix(n).mapElements((ComplexMapping)RandomMap.MAP);
    }

    public static ComplexTridiagonalMatrix randomComplexTridiagonalMatrix(int n) {
        return new ComplexTridiagonalMatrix(MatrixToolkit.toArray((AbstractComplexMatrix)MatrixToolkit.randomComplexSquareMatrix(n)));
    }

    public static ComplexDiagonalMatrix randomComplexDiagonalMatrix(int n) {
        return new ComplexDiagonalMatrix(MatrixToolkit.toArray((AbstractComplexMatrix)MatrixToolkit.randomComplexSquareMatrix(n)));
    }

    public static double[][] toArray(AbstractDoubleMatrix abstractDoubleMatrix) {
        double[][] dArray = new double[abstractDoubleMatrix.rows()][abstractDoubleMatrix.columns()];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray[i][j] = abstractDoubleMatrix.getElement(i, j);
            }
        }
        return dArray;
    }

    public static Complex[][] toArray(AbstractComplexMatrix abstractComplexMatrix) {
        Complex[][] complexArray = new Complex[abstractComplexMatrix.rows()][abstractComplexMatrix.columns()];
        for (int i = 0; i < complexArray.length; ++i) {
            for (int j = 0; j < complexArray[0].length; ++j) {
                complexArray[i][j] = abstractComplexMatrix.getElement(i, j);
            }
        }
        return complexArray;
    }
}

