/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.particles;

import JSci.physics.particles.AntiLepton;
import JSci.physics.particles.AntiTau;
import JSci.physics.particles.TauNeutrino;
import JSci.physics.particles.WMinus;
import JSci.physics.particles.WPlus;
import JSci.physics.particles.ZZero;
import JSci.physics.quantum.QuantumParticle;

public final class AntiTauNeutrino
extends AntiLepton {
    public double restMass() {
        return 0.0;
    }

    public int charge() {
        return 0;
    }

    public int eLeptonQN() {
        return 0;
    }

    public int muLeptonQN() {
        return 0;
    }

    public int tauLeptonQN() {
        return -1;
    }

    public QuantumParticle anti() {
        return new TauNeutrino();
    }

    public boolean isAnti(QuantumParticle quantumParticle) {
        return quantumParticle != null && quantumParticle instanceof TauNeutrino;
    }

    public String toString() {
        return new String("Antitau neutrino");
    }

    public AntiTau emit(WMinus wMinus) {
        AntiTau antiTau = new AntiTau();
        antiTau.momentum = this.momentum.subtract(wMinus.momentum);
        return antiTau;
    }

    public AntiTau absorb(WPlus wPlus) {
        AntiTau antiTau = new AntiTau();
        antiTau.momentum = this.momentum.add(wPlus.momentum);
        return antiTau;
    }

    public AntiTauNeutrino emit(ZZero zZero) {
        this.momentum = this.momentum.subtract(zZero.momentum);
        return this;
    }

    public AntiTauNeutrino absorb(ZZero zZero) {
        this.momentum = this.momentum.add(zZero.momentum);
        return this;
    }
}

