/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.particles;

import JSci.physics.particles.AntiElectronNeutrino;
import JSci.physics.particles.AntiLepton;
import JSci.physics.particles.Electron;
import JSci.physics.particles.Photon;
import JSci.physics.particles.WMinus;
import JSci.physics.particles.WPlus;
import JSci.physics.particles.ZZero;
import JSci.physics.quantum.QuantumParticle;

public final class Positron
extends AntiLepton {
    public double restMass() {
        return 0.510998902;
    }

    public int charge() {
        return 1;
    }

    public int eLeptonQN() {
        return -1;
    }

    public int muLeptonQN() {
        return 0;
    }

    public int tauLeptonQN() {
        return 0;
    }

    public QuantumParticle anti() {
        return new Electron();
    }

    public boolean isAnti(QuantumParticle quantumParticle) {
        return quantumParticle != null && quantumParticle instanceof Electron;
    }

    public String toString() {
        return new String("Positron");
    }

    public Positron emit(Photon photon) {
        this.momentum = this.momentum.subtract(photon.momentum);
        return this;
    }

    public Positron absorb(Photon photon) {
        this.momentum = this.momentum.add(photon.momentum);
        return this;
    }

    public AntiElectronNeutrino emit(WPlus wPlus) {
        AntiElectronNeutrino antiElectronNeutrino = new AntiElectronNeutrino();
        antiElectronNeutrino.momentum = this.momentum.subtract(wPlus.momentum);
        return antiElectronNeutrino;
    }

    public AntiElectronNeutrino absorb(WMinus wMinus) {
        AntiElectronNeutrino antiElectronNeutrino = new AntiElectronNeutrino();
        antiElectronNeutrino.momentum = this.momentum.add(wMinus.momentum);
        return antiElectronNeutrino;
    }

    public Positron emit(ZZero zZero) {
        this.momentum = this.momentum.subtract(zZero.momentum);
        return this;
    }

    public Positron absorb(ZZero zZero) {
        this.momentum = this.momentum.add(zZero.momentum);
        return this;
    }
}

