/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.quantum;

import JSci.maths.Complex;
import JSci.maths.DimensionException;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.Member;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractComplexSquareMatrix;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.ComplexVector;
import JSci.physics.quantum.KetVector;

public class Operator
implements Member {
    protected AbstractComplexSquareMatrix representation;

    public Operator(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        this.representation = abstractComplexSquareMatrix;
    }

    public boolean equals(Object object) {
        return this.representation.equals((AbstractComplexMatrix)((Operator)object).representation);
    }

    public String toString() {
        return this.representation.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.trace().mod());
    }

    public AbstractComplexSquareMatrix getRepresentation() {
        return this.representation;
    }

    public boolean isSelfAdjoint() {
        return this.representation.isHermitian();
    }

    public boolean isUnitary() {
        return this.representation.isUnitary();
    }

    public Complex trace() {
        return this.representation.trace();
    }

    public double norm() {
        try {
            return this.representation.operatorNorm();
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return -1.0;
        }
    }

    public int dimension() {
        return this.representation.columns();
    }

    public Object getSet() {
        return this.representation.getSet();
    }

    public Operator add(Operator operator) {
        return new Operator(this.representation.add(operator.representation));
    }

    public Operator subtract(Operator operator) {
        return new Operator(this.representation.subtract(operator.representation));
    }

    public Operator multiply(Operator operator) {
        return new Operator(this.representation.multiply(operator.representation));
    }

    public KetVector multiply(KetVector ketVector) {
        int n = this.dimension();
        if (n == ketVector.dimension()) {
            AbstractComplexVector abstractComplexVector = ketVector.getRepresentation();
            Complex[] complexArray = new Complex[n];
            for (int i = 0; i < n; ++i) {
                Complex complex = this.representation.getElement(i, 0).multiply(abstractComplexVector.getComponent(0));
                for (int j = 1; j < n; ++j) {
                    complex = complex.add(this.representation.getElement(i, j).multiply(abstractComplexVector.getComponent(j)));
                }
                complexArray[i] = complex;
            }
            return new KetVector((AbstractComplexVector)new ComplexVector(complexArray));
        }
        throw new DimensionException("Operator and vector have different dimensions.");
    }
}

