/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.ArrayMath;

public final class EngineerMath
extends AbstractMath {
    private EngineerMath() {
    }

    public static double[] runningAverage(double[] dArray, int n) {
        int n2;
        if (dArray.length < n) {
            throw new IllegalArgumentException("Array must be at least as long as the required width : " + dArray.length + " < " + n);
        }
        if ((n & 1) == 0) {
            throw new IllegalArgumentException("The parameter 'width' must be odd : " + n);
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Empty array, nothing to compute!");
        }
        int n3 = n >> 1;
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = ArrayMath.mean(ArrayMath.extract(0, n - 1, dArray));
        for (n2 = 1; n2 < n3; ++n2) {
            dArray2[n2] = dArray2[0];
        }
        for (n2 = n3; n2 < dArray.length - n3 - 1; ++n2) {
            dArray2[n2] = ArrayMath.mean(ArrayMath.extract(n2 - n3, n2 + n3, dArray));
        }
        dArray2[dArray.length - n3 - 1] = ArrayMath.mean(ArrayMath.extract(dArray.length - 1 - n + 1, dArray.length - 1, dArray));
        for (n2 = dArray.length - n3; n2 < dArray.length; ++n2) {
            dArray2[n2] = dArray2[dArray.length - n3 - 1];
        }
        return dArray2;
    }

    public static double[] runningMedian(double[] dArray, int n) {
        int n2;
        if (dArray.length < n) {
            throw new IllegalArgumentException("Array must be at least as long as the required width : " + dArray.length + " < " + n);
        }
        if ((n & 1) == 0) {
            throw new IllegalArgumentException("The parameter 'width' must be odd : " + n);
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Empty array, nothing to compute!");
        }
        int n3 = n >> 1;
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = ArrayMath.median(ArrayMath.extract(0, n - 1, dArray));
        for (n2 = 1; n2 < n3; ++n2) {
            dArray2[n2] = dArray2[0];
        }
        for (n2 = n3; n2 < dArray.length - n3 - 1; ++n2) {
            dArray2[n2] = ArrayMath.median(ArrayMath.extract(n2 - n3, n2 + n3, dArray));
        }
        dArray2[dArray.length - n3 - 1] = ArrayMath.median(ArrayMath.extract(dArray.length - 1 - n + 1, dArray.length - 1, dArray));
        for (n2 = dArray.length - n3; n2 < dArray.length; ++n2) {
            dArray2[n2] = dArray2[dArray.length - n3 - 1];
        }
        return dArray2;
    }

    public static double icf(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            if (dArray[i] < 0.0) {
                throw new IllegalArgumentException("You cannot take the ICF of a array having negative components : v [" + i + "] = " + dArray[i] + " < 0");
            }
            d -= dArray[i] * Math.log(dArray[i]);
        }
        return d;
    }

    public static double entropy(double[] dArray) {
        double[] dArray2 = ArrayMath.abs(dArray);
        double d = ArrayMath.mass(dArray2);
        if (d == 0.0) {
            return 0.0;
        }
        dArray2 = ArrayMath.scalarMultiply(1.0 / d, dArray2);
        return EngineerMath.icf(dArray2);
    }

    public static double entropy(int[] nArray) {
        int[] nArray2 = ArrayMath.abs(nArray);
        int n = ArrayMath.mass(nArray2);
        if (n == 0) {
            return 0.0;
        }
        double[] dArray = ArrayMath.scalarMultiply(1.0 / (double)n, nArray2);
        return EngineerMath.icf(dArray);
    }

    public static double[] resample(double[] dArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("New length must be strictly positive : " + n + " <=0 ");
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = (double)i / (double)(n - 1) * (double)(dArray.length - 1);
            int n2 = (int)Math.floor(d);
            int n3 = (int)Math.ceil(d);
            double d2 = d - (double)n2;
            dArray2[i] = dArray[n2] * d2 + dArray[n3] * (1.0 - d2);
        }
        return dArray2;
    }
}

