/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.ExtraMath;
import JSci.maths.fields.Field;
import JSci.maths.fields.RealField;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public final class MathDouble
extends Number
implements Comparable,
Field.Member {
    private static final long serialVersionUID = 8616680319093653108L;
    private final double x;

    public MathDouble(double d) {
        this.x = d;
    }

    public MathDouble(String string) throws NumberFormatException {
        this.x = Double.parseDouble(string);
    }

    public boolean equals(Object object) {
        return this.equals(object, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(Object object, double d) {
        if (object instanceof Number) {
            return Math.abs(this.x - ((Number)object).doubleValue()) <= d;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.x;
    }

    public int compareTo(Object object) throws IllegalArgumentException {
        if (object != null && object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (Math.abs(this.x - d) <= GlobalSettings.ZERO_TOL) {
                return 0;
            }
            return this.x < d ? -1 : 1;
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass());
    }

    public String toString() {
        return Double.toString(this.x);
    }

    public double value() {
        return this.x;
    }

    public int intValue() {
        return (int)this.x;
    }

    public long longValue() {
        return (long)this.x;
    }

    public float floatValue() {
        return (float)this.x;
    }

    public double doubleValue() {
        return this.x;
    }

    public static boolean isZero(double d) {
        return Math.abs(d) <= GlobalSettings.ZERO_TOL;
    }

    public boolean isNaN() {
        return this.x == Double.NaN;
    }

    public boolean isInfinite() {
        return this.x == Double.POSITIVE_INFINITY || this.x == Double.NEGATIVE_INFINITY;
    }

    public Object getSet() {
        return RealField.getInstance();
    }

    public AbelianGroup.Member negate() {
        return new MathDouble(-this.x);
    }

    public Field.Member inverse() {
        return new MathDouble(1.0 / this.x);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof Number) {
            return this.add(((Number)((Object)member)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + member.getClass());
    }

    public MathDouble add(MathDouble mathDouble) {
        return this.add(mathDouble.x);
    }

    public MathDouble add(double d) {
        return new MathDouble(this.x + d);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof Number) {
            return this.subtract(((Number)((Object)member)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + member.getClass());
    }

    public MathDouble subtract(MathDouble mathDouble) {
        return this.subtract(mathDouble.x);
    }

    public MathDouble subtract(double d) {
        return new MathDouble(this.x - d);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof Number) {
            return this.multiply(((Number)((Object)member)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + member.getClass());
    }

    public MathDouble multiply(MathDouble mathDouble) {
        return this.multiply(mathDouble.x);
    }

    public MathDouble multiply(double d) {
        return new MathDouble(this.x * d);
    }

    public Field.Member divide(Field.Member member) {
        if (member instanceof Number) {
            return this.divide(((Number)((Object)member)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + member.getClass());
    }

    public MathDouble divide(MathDouble mathDouble) {
        return this.divide(mathDouble.x);
    }

    public MathDouble divide(double d) {
        return new MathDouble(this.x / d);
    }

    public static MathDouble exp(MathDouble mathDouble) {
        return MathDouble.exp(mathDouble.x);
    }

    public static MathDouble exp(Number number) {
        return MathDouble.exp(number.doubleValue());
    }

    public static MathDouble exp(double d) {
        return new MathDouble(Math.exp(d));
    }

    public static MathDouble log(MathDouble mathDouble) {
        return MathDouble.log(mathDouble.x);
    }

    public static MathDouble log(Number number) {
        return MathDouble.log(number.doubleValue());
    }

    public static MathDouble log(double d) {
        return new MathDouble(Math.log(d));
    }

    public static MathDouble sin(MathDouble mathDouble) {
        return MathDouble.sin(mathDouble.x);
    }

    public static MathDouble sin(Number number) {
        return MathDouble.sin(number.doubleValue());
    }

    public static MathDouble sin(double d) {
        return new MathDouble(Math.sin(d));
    }

    public static MathDouble cos(MathDouble mathDouble) {
        return MathDouble.cos(mathDouble.x);
    }

    public static MathDouble cos(Number number) {
        return MathDouble.cos(number.doubleValue());
    }

    public static MathDouble cos(double d) {
        return new MathDouble(Math.cos(d));
    }

    public static MathDouble tan(MathDouble mathDouble) {
        return MathDouble.tan(mathDouble.x);
    }

    public static MathDouble tan(Number number) {
        return MathDouble.tan(number.doubleValue());
    }

    public static MathDouble tan(double d) {
        return new MathDouble(Math.tan(d));
    }

    public static MathDouble sinh(MathDouble mathDouble) {
        return MathDouble.sinh(mathDouble.x);
    }

    public static MathDouble sinh(Number number) {
        return MathDouble.sinh(number.doubleValue());
    }

    public static MathDouble sinh(double d) {
        return new MathDouble(ExtraMath.sinh(d));
    }

    public static MathDouble cosh(MathDouble mathDouble) {
        return MathDouble.cosh(mathDouble.x);
    }

    public static MathDouble cosh(Number number) {
        return MathDouble.cosh(number.doubleValue());
    }

    public static MathDouble cosh(double d) {
        return new MathDouble(ExtraMath.cosh(d));
    }

    public static MathDouble tanh(MathDouble mathDouble) {
        return MathDouble.tanh(mathDouble.x);
    }

    public static MathDouble tanh(Number number) {
        return MathDouble.tanh(number.doubleValue());
    }

    public static MathDouble tanh(double d) {
        return new MathDouble(ExtraMath.tanh(d));
    }

    public static MathDouble asin(MathDouble mathDouble) {
        return MathDouble.asin(mathDouble.x);
    }

    public static MathDouble asin(Number number) {
        return MathDouble.asin(number.doubleValue());
    }

    public static MathDouble asin(double d) {
        return new MathDouble(Math.asin(d));
    }

    public static MathDouble acos(MathDouble mathDouble) {
        return MathDouble.acos(mathDouble.x);
    }

    public static MathDouble acos(Number number) {
        return MathDouble.acos(number.doubleValue());
    }

    public static MathDouble acos(double d) {
        return new MathDouble(Math.acos(d));
    }

    public static MathDouble atan(MathDouble mathDouble) {
        return MathDouble.atan(mathDouble.x);
    }

    public static MathDouble atan(Number number) {
        return MathDouble.atan(number.doubleValue());
    }

    public static MathDouble atan(double d) {
        return new MathDouble(Math.atan(d));
    }

    public static MathDouble asinh(MathDouble mathDouble) {
        return MathDouble.asinh(mathDouble.x);
    }

    public static MathDouble asinh(Number number) {
        return MathDouble.asinh(number.doubleValue());
    }

    public static MathDouble asinh(double d) {
        return new MathDouble(ExtraMath.asinh(d));
    }

    public static MathDouble acosh(MathDouble mathDouble) {
        return MathDouble.acosh(mathDouble.x);
    }

    public static MathDouble acosh(Number number) {
        return MathDouble.acosh(number.doubleValue());
    }

    public static MathDouble acosh(double d) {
        return new MathDouble(ExtraMath.acosh(d));
    }

    public static MathDouble atanh(MathDouble mathDouble) {
        return MathDouble.atanh(mathDouble.x);
    }

    public static MathDouble atanh(Number number) {
        return MathDouble.atanh(number.doubleValue());
    }

    public static MathDouble atanh(double d) {
        return new MathDouble(ExtraMath.atanh(d));
    }
}

