/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.ArrayMath;
import JSci.maths.ExtraMath;
import JSci.maths.Mapping;
import JSci.maths.MappingND;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.analysis.RealFunction;
import JSci.maths.analysis.RealFunction2D;

public final class NumericalMath
extends AbstractMath {
    private NumericalMath() {
    }

    public static double[] solveQuadratic(double d, double d2, double d3) {
        double[] dArray = new double[2];
        double d4 = d2 < 0.0 ? (-d2 + Math.sqrt(d2 * d2 - 4.0 * d * d3)) / 2.0 : (-d2 - Math.sqrt(d2 * d2 - 4.0 * d * d3)) / 2.0;
        dArray[0] = d4 / d;
        dArray[1] = d3 / d4;
        return dArray;
    }

    public static double bisection(Mapping mapping, double d, double d2, int n, double d3) throws MaximumIterationsExceededException {
        double d4;
        int n2;
        int n3 = ExtraMath.sign(mapping.map(d));
        if (n3 == (n2 = ExtraMath.sign(mapping.map(d2)))) {
            throw new IllegalArgumentException("Bounds do not bracket a root.");
        }
        int n4 = 0;
        do {
            int n5;
            if ((n5 = ExtraMath.sign(mapping.map(d4 = (d + d2) / 2.0))) == n3) {
                d = d4;
            } else if (n5 == n2) {
                d2 = d4;
            } else {
                d = d4;
                d2 = d4;
            }
            if (++n4 <= n) continue;
            throw new MaximumIterationsExceededException("No convergence after " + n + " iterations.");
        } while (Math.abs(d - d2) > d3);
        return d4;
    }

    public static double falsePosition(Mapping mapping, double d, double d2, int n, double d3) throws MaximumIterationsExceededException {
        double d4;
        double d5;
        int n2;
        double d6 = mapping.map(d);
        double d7 = mapping.map(d2);
        int n3 = ExtraMath.sign(d6);
        if (n3 == (n2 = ExtraMath.sign(d7))) {
            throw new IllegalArgumentException("Bounds do not bracket a root.");
        }
        int n4 = 0;
        do {
            double d8;
            int n5;
            if ((n5 = ExtraMath.sign(d8 = mapping.map(d4 = d - (d2 - d) * d6 / (d7 - d6)))) == n3) {
                d5 = d4 - d;
                d = d4;
                d6 = d8;
            } else if (n5 == n2) {
                d5 = d2 - d4;
                d2 = d4;
                d7 = d8;
            } else {
                d5 = 0.0;
            }
            if (++n4 <= n) continue;
            throw new MaximumIterationsExceededException("No convergence after " + n + " iterations.");
        } while (Math.abs(d5) > d3);
        return d4;
    }

    public static double newtonRaphson(RealFunction realFunction, double d, int n, double d2) throws MaximumIterationsExceededException {
        double d3;
        RealFunction realFunction2 = realFunction.differentiate();
        int n2 = 0;
        do {
            d3 = -realFunction.map(d) / realFunction2.map(d);
            d += d3;
            if (++n2 <= n) continue;
            throw new MaximumIterationsExceededException("No convergence after " + n + " iterations.");
        } while (Math.abs(d3) > d2);
        return d;
    }

    public static double[] euler(double[] dArray, Mapping mapping, double d) {
        for (int i = 0; i < dArray.length - 1; ++i) {
            dArray[i + 1] = dArray[i] + d * mapping.map(dArray[i]);
        }
        return dArray;
    }

    public static double[] leapFrog(double[] dArray, Mapping mapping, double d) {
        double d2 = 2.0 * d;
        for (int i = 1; i < dArray.length - 1; ++i) {
            dArray[i + 1] = dArray[i - 1] + d2 * mapping.map(dArray[i]);
        }
        return dArray;
    }

    public static double[] rungeKutta2(double[] dArray, Mapping mapping, double d) {
        double d2 = d / 2.0;
        for (int i = 0; i < dArray.length - 1; ++i) {
            dArray[i + 1] = dArray[i] + d * mapping.map(dArray[i] + d2 * mapping.map(dArray[i]));
        }
        return dArray;
    }

    public static double[] rungeKutta2(double[] dArray, RealFunction2D realFunction2D, double d, double d2) {
        double d3 = d2 / 2.0;
        double d4 = d;
        for (int i = 0; i < dArray.length - 1; ++i) {
            dArray[i + 1] = dArray[i] + d2 * realFunction2D.map(dArray[i] + d3 * realFunction2D.map(dArray[i], d4), d4 + d3);
            d4 += d2;
        }
        return dArray;
    }

    public static double[] rungeKutta4(double[] dArray, Mapping mapping, double d) {
        for (int i = 0; i < dArray.length - 1; ++i) {
            double d2 = d * mapping.map(dArray[i]);
            double d3 = d * mapping.map(dArray[i] + d2 / 2.0);
            double d4 = d * mapping.map(dArray[i] + d3 / 2.0);
            double d5 = d * mapping.map(dArray[i] + d4);
            dArray[i + 1] = dArray[i] + (d2 + d5) / 6.0 + (d3 + d4) / 3.0;
        }
        return dArray;
    }

    public static double[] rungeKutta4(double[] dArray, RealFunction2D realFunction2D, double d, double d2) {
        double d3 = d2 / 2.0;
        double d4 = d;
        for (int i = 0; i < dArray.length - 1; ++i) {
            double d5 = d2 * realFunction2D.map(dArray[i], d4);
            double d6 = d2 * realFunction2D.map(dArray[i] + d5 / 2.0, d4 + d3);
            double d7 = d2 * realFunction2D.map(dArray[i] + d6 / 2.0, d4 + d3);
            double d8 = d2 * realFunction2D.map(dArray[i] + d7, d4 + d2);
            dArray[i + 1] = dArray[i] + (d5 + d8) / 6.0 + (d6 + d7) / 3.0;
            d4 += d2;
        }
        return dArray;
    }

    public static double trapezium(int n, Mapping mapping, double d, double d2) {
        double d3 = 0.0;
        double d4 = d;
        double d5 = (d2 - d) / (double)n;
        for (int i = 0; i < n; ++i) {
            d3 += mapping.map(d4) + mapping.map(d4 + d5);
            d4 += d5;
        }
        return d3 * d5 / 2.0;
    }

    public static double simpson(int n, Mapping mapping, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = d;
        double d6 = (d2 - d) / (double)(2 * n);
        for (int i = 0; i < n - 1; ++i) {
            d3 += mapping.map(d5 + d6);
            d4 += mapping.map(d5 + 2.0 * d6);
            d5 += 2.0 * d6;
        }
        return d6 / 3.0 * (mapping.map(d) + 4.0 * (d3 += mapping.map(d5 + d6)) + 2.0 * d4 + mapping.map(d2));
    }

    public static double richardson(int n, Mapping mapping, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = d;
        double d8 = (d2 - d) / (double)(2 * n);
        double d9 = d8 / 2.0;
        for (int i = 0; i < n - 1; ++i) {
            d3 += mapping.map(d7 + d8);
            d4 += mapping.map(d7 + 2.0 * d8);
            d5 += mapping.map(d7 + d9);
            d6 += mapping.map(d7 + 2.0 * d9);
            d5 += mapping.map(d7 + 3.0 * d9);
            d6 += mapping.map(d7 + 4.0 * d9);
            d7 += 2.0 * d8;
        }
        d5 += mapping.map(d7 + d9);
        double d10 = d8 / 3.0 * (mapping.map(d) + 4.0 * (d3 += mapping.map(d7 + d8)) + 2.0 * d4 + mapping.map(d2));
        double d11 = d9 / 3.0 * (mapping.map(d) + 4.0 * (d5 += mapping.map(d7 + 3.0 * d9)) + 2.0 * (d6 += mapping.map(d7 + 2.0 * d9)) + mapping.map(d2));
        return (16.0 * d11 - d10) / 15.0;
    }

    public static double gaussian4(int n, Mapping mapping, double d, double d2) {
        double d3 = 0.0;
        double d4 = (d2 - d) / (double)n;
        double d5 = d4 / 2.0;
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        dArray[2] = 0.33998104358485626;
        dArray[3] = 0.8611363115940526;
        dArray[0] = -dArray[3];
        dArray[1] = -dArray[2];
        dArray2[3] = 0.34785484513745385;
        dArray2[0] = 0.34785484513745385;
        dArray2[2] = 0.6521451548625461;
        dArray2[1] = 0.6521451548625461;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                d3 += dArray2[j] * mapping.map(d + (dArray[j] + 1.0) * d5);
            }
            d += d4;
        }
        return d3 * d5;
    }

    public static double gaussian8(int n, Mapping mapping, double d, double d2) {
        double d3 = 0.0;
        double d4 = (d2 - d) / (double)n;
        double d5 = d4 / 2.0;
        double[] dArray = new double[8];
        double[] dArray2 = new double[8];
        dArray[4] = 0.1834346424956498;
        dArray[5] = 0.525532409916329;
        dArray[6] = 0.7966664774136267;
        dArray[7] = 0.9602898564975363;
        dArray[0] = -dArray[7];
        dArray[1] = -dArray[6];
        dArray[2] = -dArray[5];
        dArray[3] = -dArray[4];
        dArray2[7] = 0.10122853629037626;
        dArray2[0] = 0.10122853629037626;
        dArray2[6] = 0.22238103445337448;
        dArray2[1] = 0.22238103445337448;
        dArray2[5] = 0.31370664587788727;
        dArray2[2] = 0.31370664587788727;
        dArray2[4] = 0.362683783378362;
        dArray2[3] = 0.362683783378362;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                d3 += dArray2[j] * mapping.map(d + (dArray[j] + 1.0) * d5);
            }
            d += d4;
        }
        return d3 * d5;
    }

    public static double[] differentiate(int n, Mapping mapping, double d, double d2) {
        double[] dArray = new double[n];
        double d3 = d;
        double d4 = (d2 - d) / (double)n;
        double d5 = d4 / 2.0;
        for (int i = 0; i < n; ++i) {
            dArray[i] = (mapping.map(d3 + d5) - mapping.map(d3 - d5)) / d4;
            d3 += d4;
        }
        return dArray;
    }

    public static double[][] differentiate(MappingND mappingND, double[] dArray, double[] dArray2) {
        int n;
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray, 0, dArray4, 0, dArray.length);
        dArray3[0] = dArray3[0] + dArray2[0];
        dArray4[0] = dArray4[0] - dArray2[0];
        double[] dArray5 = ArrayMath.scalarMultiply(0.5 / dArray2[0], ArrayMath.subtract(mappingND.map(dArray3), mappingND.map(dArray4)));
        double[][] dArray6 = new double[dArray5.length][dArray.length];
        for (n = 0; n < dArray5.length; ++n) {
            dArray6[n][0] = dArray5[n];
        }
        for (int i = 1; i < dArray.length; ++i) {
            System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
            System.arraycopy(dArray, 0, dArray4, 0, dArray.length);
            int n2 = i;
            dArray3[n2] = dArray3[n2] + dArray2[i];
            int n3 = i;
            dArray4[n3] = dArray4[n3] - dArray2[i];
            dArray5 = ArrayMath.scalarMultiply(0.5 / dArray2[i], ArrayMath.subtract(mappingND.map(dArray3), mappingND.map(dArray4)));
            for (n = 0; n < dArray5.length; ++n) {
                dArray6[n][i] = dArray5[n];
            }
        }
        return dArray6;
    }

    public static double[] metropolis(double[] dArray, Mapping mapping, double d) {
        for (int i = 0; i < dArray.length - 1; ++i) {
            dArray[i + 1] = dArray[i] + d * (2.0 * Math.random() - 1.0);
            if (!(mapping.map(dArray[i + 1]) / mapping.map(dArray[i]) < Math.random())) continue;
            dArray[i + 1] = dArray[i];
        }
        return dArray;
    }
}

