/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.ArrayMath;
import JSci.maths.Complex;

public final class WaveletMath
extends AbstractMath {
    private WaveletMath() {
    }

    public static Complex[] downsample(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        int n2 = Math.round((float)n / 2.0f - 0.5f);
        int n3 = complexArray2.length;
        int n4 = Math.round((float)n3 / 2.0f - 0.5f);
        Complex[] complexArray3 = new Complex[n4];
        for (int i = 0; i < n4; ++i) {
            complexArray3[i] = Complex.ZERO;
            for (int j = Math.max(0, 2 * i - n2 + 1); j < Math.min(n3, 2 * i + n - n2 + 1); ++j) {
                complexArray3[i] = complexArray3[i].add(complexArray2[j].multiply(complexArray[j - 2 * i + n2 - 1]));
            }
        }
        return complexArray3;
    }

    public static double[] downsample(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = Math.round((float)n / 2.0f - 0.5f);
        int n3 = dArray2.length;
        int n4 = Math.round((float)n3 / 2.0f - 0.5f);
        double[] dArray3 = new double[n4];
        for (int i = 0; i < n4; ++i) {
            dArray3[i] = 0.0;
            for (int j = Math.max(0, 2 * i - n2 + 1); j < Math.min(n3, 2 * i + n - n2 + 1); ++j) {
                int n5 = i;
                dArray3[n5] = dArray3[n5] + dArray2[j] * dArray[j - 2 * i + n2 - 1];
            }
        }
        return dArray3;
    }

    public static Complex[] upsample(Complex[] complexArray) {
        int n = complexArray.length;
        Complex[] complexArray2 = new Complex[2 * n];
        for (int i = 0; i < n; ++i) {
            complexArray2[2 * i] = complexArray[i];
            complexArray2[2 * i + 1] = Complex.ZERO;
        }
        return complexArray2;
    }

    public static double[] upsample(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[2 * n];
        for (int i = 0; i < n; ++i) {
            dArray2[2 * i] = dArray[i];
            dArray2[2 * i + 1] = 0.0;
        }
        return dArray2;
    }

    public static Complex[] upsample(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        int n2 = Math.round((float)n / 2.0f - 0.5f);
        int n3 = complexArray2.length;
        Complex[] complexArray3 = new Complex[2 * n3];
        Complex[] complexArray4 = new Complex[2 * n3];
        complexArray4 = WaveletMath.upsample(complexArray2);
        for (int i = 0; i < 2 * n3; ++i) {
            complexArray3[i] = Complex.ZERO;
            for (int j = Math.max(0, i - n2); j < Math.min(2 * n3, i + n - n2); ++j) {
                complexArray3[i] = complexArray3[i].add(complexArray4[j].multiply(complexArray[i + n - n2 - j - 1]));
            }
        }
        return complexArray3;
    }

    public static double[] upsample(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = Math.round((float)n / 2.0f - 0.5f);
        int n3 = dArray2.length;
        double[] dArray3 = new double[2 * n3];
        double[] dArray4 = new double[2 * n3];
        dArray4 = WaveletMath.upsample(dArray2);
        for (int i = 0; i < 2 * n3; ++i) {
            dArray3[i] = 0.0;
            for (int j = Math.max(0, i - n2); j < Math.min(2 * n3, i + n - n2); ++j) {
                int n4 = i;
                dArray3[n4] = dArray3[n4] + dArray4[j] * dArray[i + n - n2 - j - 1];
            }
        }
        return dArray3;
    }

    public static double[] lowToHigh(double[] dArray) {
        double[] dArray2 = ArrayMath.invert(dArray);
        int n = 1;
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = (double)n * dArray2[i];
            n = -n;
        }
        return dArray2;
    }
}

