/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.groups;

import JSci.maths.groups.AbelianGroup;
import JSci.maths.groups.FiniteGroup;
import JSci.maths.groups.Group;
import JSci.maths.groups.Monoid;
import JSci.maths.groups.Semigroup;

public final class CyclicGroup
extends FiniteGroup
implements AbelianGroup {
    private final Member ZERO = new Member(0);

    public CyclicGroup(int n) {
        super(n);
    }

    public boolean equals(Object object) {
        return object instanceof CyclicGroup && ((CyclicGroup)object).order == this.order;
    }

    public int hashCode() {
        return this.order;
    }

    public String toString() {
        return "Z_" + this.order;
    }

    public Member getElement(int n) {
        return new Member(n);
    }

    public Group.Member[] getElements() {
        Group.Member[] memberArray = new Group.Member[this.order];
        for (int i = 0; i < this.order; ++i) {
            memberArray[i] = this.getElement(i);
        }
        return memberArray;
    }

    public AbelianGroup.Member zero() {
        return this.ZERO;
    }

    public boolean isZero(AbelianGroup.Member member) {
        return member.equals(this.ZERO);
    }

    public boolean isNegative(AbelianGroup.Member member, AbelianGroup.Member member2) {
        return member instanceof Member && member2 instanceof Member && member.add(member2).equals(this.ZERO);
    }

    public Monoid.Member identity() {
        return this.ZERO;
    }

    public boolean isIdentity(Monoid.Member member) {
        return member.equals(this.ZERO);
    }

    public boolean isInverse(Group.Member member, Group.Member member2) {
        return member instanceof Member && member2 instanceof Member && member.compose(member2).equals(this.ZERO);
    }

    class Member
    implements AbelianGroup.Member,
    Group.Member {
        private final int i;

        public Member(int n) {
            this.i = n < 0 ? n % CyclicGroup.this.order + CyclicGroup.this.order : n % CyclicGroup.this.order;
        }

        public boolean equals(Object object) {
            return object instanceof Member && this.i == ((Member)object).i;
        }

        public int hashCode() {
            return this.i;
        }

        public Object getSet() {
            return CyclicGroup.this;
        }

        public AbelianGroup.Member add(AbelianGroup.Member member) {
            return new Member(this.i + ((Member)member).i);
        }

        public AbelianGroup.Member negate() {
            return new Member(-this.i);
        }

        public AbelianGroup.Member subtract(AbelianGroup.Member member) {
            return new Member(this.i - ((Member)member).i);
        }

        public Semigroup.Member compose(Semigroup.Member member) {
            return new Member(this.i + ((Member)member).i);
        }

        public Group.Member inverse() {
            return new Member(-this.i);
        }
    }
}

