/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.groups;

import JSci.maths.groups.FiniteGroup;
import JSci.maths.groups.Group;
import JSci.maths.groups.Monoid;
import JSci.maths.groups.Semigroup;

public final class QuaternionGroup
extends FiniteGroup {
    private static final QuaternionGroup _instance = new QuaternionGroup();
    private final Member ONE = new Member(1);
    private static final int[][] multTable = new int[][]{{1, 2, 3, 4}, {2, -1, 4, -3}, {3, -4, -1, 2}, {4, 3, -2, -1}};

    private QuaternionGroup() {
        super(8);
    }

    public static final QuaternionGroup getInstance() {
        return _instance;
    }

    public String toString() {
        return "Q";
    }

    public Group.Member[] getElements() {
        return new Group.Member[]{new Member(1), new Member(2), new Member(3), new Member(4), new Member(-1), new Member(-2), new Member(-3), new Member(-4)};
    }

    public Monoid.Member identity() {
        return this.ONE;
    }

    public boolean isIdentity(Monoid.Member member) {
        return member.equals(this.ONE);
    }

    public boolean isInverse(Group.Member member, Group.Member member2) {
        return member instanceof Member && member2 instanceof Member && member.compose(member2).equals(this.ONE);
    }

    class Member
    implements Group.Member {
        private final int unit;

        public Member(int n) {
            if (n < -4 || n == 0 || n > 4) {
                throw new IllegalArgumentException();
            }
            this.unit = n;
        }

        public boolean equals(Object object) {
            return object instanceof Member && this.unit == ((Member)object).unit;
        }

        public int hashCode() {
            return this.unit;
        }

        public Object getSet() {
            return QuaternionGroup.this;
        }

        public Semigroup.Member compose(Semigroup.Member member) {
            int n = ((Member)member).unit;
            if (this.unit > 0 && n > 0) {
                return new Member(multTable[this.unit][n]);
            }
            if (this.unit > 0 && n < 0) {
                return new Member(-multTable[this.unit][-n]);
            }
            if (this.unit < 0 && n > 0) {
                return new Member(-multTable[-this.unit][n]);
            }
            return new Member(multTable[-this.unit][-n]);
        }

        public Group.Member inverse() {
            return new Member(-this.unit);
        }
    }
}

