/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.maths.ExtraMath;
import JSci.maths.Mapping;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.matrices.ComplexMatrix;
import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleMatrixAlgebra;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.IntegerMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;

public abstract class AbstractDoubleMatrix
extends Matrix {
    protected AbstractDoubleMatrix(int n, int n2) {
        super(n, n2);
    }

    public final boolean equals(Object object) {
        if (object instanceof AbstractDoubleMatrix) {
            return this.equals((AbstractDoubleMatrix)object);
        }
        return false;
    }

    public final boolean equals(AbstractDoubleMatrix abstractDoubleMatrix) {
        return this.equals(abstractDoubleMatrix, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(AbstractDoubleMatrix abstractDoubleMatrix, double d) {
        if (abstractDoubleMatrix != null && this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double d2 = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double d3 = this.getElement(i, j) - abstractDoubleMatrix.getElement(i, j);
                    d2 += d3 * d3;
                }
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.getElement(i, j));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                nArray[i][j] = Math.round((float)this.getElement(i, j));
            }
        }
        return new IntegerMatrix(nArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        ComplexMatrix complexMatrix = new ComplexMatrix(this.numRows, this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                complexMatrix.setElement(i, j, this.getElement(i, j), 0.0);
            }
        }
        return complexMatrix;
    }

    public abstract double getElement(int var1, int var2);

    public abstract void setElement(int var1, int var2, double var3);

    public final Object getSet() {
        return DoubleMatrixAlgebra.get(this.numRows, this.numCols);
    }

    public double infNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                d2 += Math.abs(this.getElement(i, j));
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                d = ExtraMath.hypot(d, this.getElement(i, j));
            }
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = -this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = -this.getElement(i, j);
            }
        }
        return new DoubleMatrix(dArray);
    }

    public final AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleMatrix) {
            return this.add((AbstractDoubleMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix add(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.getElement(i, 0) + abstractDoubleMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.getElement(i, j) + abstractDoubleMatrix.getElement(i, j);
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleMatrix) {
            return this.subtract((AbstractDoubleMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix subtract(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.getElement(i, 0) - abstractDoubleMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.getElement(i, j) - abstractDoubleMatrix.getElement(i, j);
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof Number) {
            return this.scalarMultiply(((Number)((Object)member)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = d * this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = d * this.getElement(i, j);
            }
        }
        return new DoubleMatrix(dArray);
    }

    public final VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof Number) {
            return this.scalarDivide(((Number)((Object)member)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = this.getElement(i, 0) / d;
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = this.getElement(i, j) / d;
            }
        }
        return new DoubleMatrix(dArray);
    }

    public double scalarProduct(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double d = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                d += this.getElement(i, 0) * abstractDoubleMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    d += this.getElement(i, j) * abstractDoubleMatrix.getElement(i, j);
                }
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i] = this.getElement(i, 0) * abstractDoubleVector.getComponent(0);
                for (int j = 1; j < this.numCols; ++j) {
                    int n = i;
                    dArray[n] = dArray[n] + this.getElement(i, j) * abstractDoubleVector.getComponent(j);
                }
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public final Ring.Member multiply(Ring.Member member) {
        if (member instanceof AbstractDoubleMatrix) {
            return this.multiply((AbstractDoubleMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix multiply(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (this.numCols == abstractDoubleMatrix.rows()) {
            int n = abstractDoubleMatrix.columns();
            double[][] dArray = new double[this.numRows][n];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray[i][j] = this.getElement(i, 0) * abstractDoubleMatrix.getElement(0, j);
                    for (int k = 1; k < this.numCols; ++k) {
                        double[] dArray2 = dArray[i];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + this.getElement(i, k) * abstractDoubleMatrix.getElement(k, j);
                    }
                }
            }
            if (this.numRows == n) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix directSum(AbstractDoubleMatrix abstractDoubleMatrix) {
        int n;
        int n2;
        double[][] dArray = new double[this.numRows + abstractDoubleMatrix.numRows][this.numCols + abstractDoubleMatrix.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                dArray[n2][n] = this.getElement(n2, n);
            }
        }
        for (n2 = 0; n2 < abstractDoubleMatrix.numRows; ++n2) {
            for (n = 0; n < abstractDoubleMatrix.numCols; ++n) {
                dArray[n2 + this.numRows][n + this.numCols] = abstractDoubleMatrix.getElement(n2, n);
            }
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractDoubleMatrix tensor(AbstractDoubleMatrix abstractDoubleMatrix) {
        double[][] dArray = new double[this.numRows * abstractDoubleMatrix.numRows][this.numCols * abstractDoubleMatrix.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n = 0;
                while (n < abstractDoubleMatrix.numRows) {
                    for (int k = 0; k < abstractDoubleMatrix.numCols; ++k) {
                        dArray[i * abstractDoubleMatrix.numRows + n][j * abstractDoubleMatrix.numCols + k] = this.getElement(i, j) * abstractDoubleMatrix.getElement(n, k);
                    }
                    ++j;
                }
            }
        }
        return new DoubleMatrix(dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[0][i] = this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[j][i] = this.getElement(i, j);
            }
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = mapping.map(this.getElement(i, 0));
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = mapping.map(this.getElement(i, j));
            }
        }
        return new DoubleMatrix(dArray);
    }
}

