/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.ExtraMath;
import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class BinomialDistribution
extends ProbabilityDistribution {
    private int n;
    private double p;

    public BinomialDistribution(int n, double d) {
        if (n <= 0) {
            throw new OutOfRangeException("The number of trials should be (strictly) positive.");
        }
        this.n = n;
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException("The probability should be between 0 and 1.");
        }
        this.p = d;
    }

    public int getTrialsParameter() {
        return this.n;
    }

    public double getProbabilityParameter() {
        return this.p;
    }

    public double getMean() {
        return (double)this.n * this.p;
    }

    public double getVariance() {
        return (double)this.n * this.p * (1.0 - this.p);
    }

    public double probability(double d) {
        this.checkRange(d, 0.0, this.n);
        return ExtraMath.binomial((double)this.n, d) * Math.pow(this.p, d) * Math.pow(1.0 - this.p, (double)this.n - d);
    }

    public double cumulative(double d) {
        this.checkRange(d, 0.0, this.n);
        double d2 = 0.0;
        for (double d3 = 0.0; d3 <= d; d3 += 1.0) {
            d2 += this.probability(d3);
        }
        return d2;
    }

    public double inverse(double d) {
        this.checkRange(d);
        return Math.floor(this.findRoot(d, (double)this.n / 2.0, 0.0, this.n));
    }
}

