/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.symbolic;

import JSci.maths.MathDouble;
import JSci.maths.analysis.Exponential;
import JSci.maths.analysis.RealFunction;
import JSci.maths.fields.RealField;
import JSci.maths.symbolic.Constant;
import JSci.maths.symbolic.Expression;
import JSci.maths.symbolic.Variable;

public class Evaluation
extends Expression {
    private final RealFunction fn;
    private final Expression arg;
    static /* synthetic */ Class class$JSci$maths$symbolic$Evaluation;

    public Evaluation(RealFunction realFunction, Expression expression) {
        this.fn = realFunction;
        this.arg = expression;
    }

    public String toString() {
        return "f<" + this.fn + ">" + "(" + this.arg + ")";
    }

    public int getPriority() {
        return 15;
    }

    public Expression differentiate(Variable variable) {
        return Expression.product(new Evaluation(this.fn.differentiate(), this.arg), this.arg.differentiate(variable));
    }

    public boolean equals(Object object) {
        if (!(class$JSci$maths$symbolic$Evaluation == null ? (class$JSci$maths$symbolic$Evaluation = Evaluation.class$("JSci.maths.symbolic.Evaluation")) : class$JSci$maths$symbolic$Evaluation).isInstance(object)) {
            return false;
        }
        Evaluation evaluation = (Evaluation)object;
        return this.fn.equals(evaluation.fn) && this.arg.equals(evaluation.arg);
    }

    public Object getSet() {
        return RealField.getInstance();
    }

    public Expression evaluate() {
        Expression expression = this.arg.evaluate();
        if (expression instanceof Constant) {
            MathDouble mathDouble = (MathDouble)((Constant)expression).getValue();
            return new Constant(new MathDouble(this.fn.map(mathDouble.doubleValue())));
        }
        return new Evaluation(this.fn, expression);
    }

    public static void main(String[] stringArray) {
        Variable variable = new Variable("x", RealField.getInstance());
        Evaluation evaluation = new Evaluation(new Exponential(1.0, 1.0, 0.0), variable);
        System.out.println("expr = " + evaluation);
        variable.setValue(new MathDouble(1.0));
        System.out.println("x = 1");
        System.out.println("expr = " + ((Expression)evaluation).evaluate());
        variable.setValue(null);
        System.out.println("d/dx expr = " + ((Expression)evaluation).differentiate(variable).evaluate());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

