/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl2;

import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PMetadata;
import processing.opengl2.PGraphicsOpenGL2;
import processing.opengl2.PTexture;

class PFontTexture
extends PMetadata
implements PConstants {
    protected PApplet parent;
    protected PFont font;
    protected int maxTexWidth;
    protected int maxTexHeight;
    protected int offsetX;
    protected int offsetY;
    protected int lineHeight;
    protected PTexture[] textures = null;
    protected int currentTex;
    protected int lastTex;
    protected TextureInfo[] glyphTexinfos;
    protected HashMap<PFont.Glyph, TextureInfo> texinfoMap;

    public PFontTexture(PApplet parent, PFont font, int maxw, int maxh) {
        this.parent = parent;
        this.font = font;
        this.initTexture(maxw, maxh);
    }

    public void delete() {
        int i = 0;
        while (i < this.textures.length) {
            this.textures[i].delete();
            ++i;
        }
    }

    protected void initTexture(int w, int h) {
        this.maxTexWidth = w;
        this.maxTexHeight = h;
        this.currentTex = -1;
        this.lastTex = -1;
        this.addTexture();
        this.offsetX = 0;
        this.offsetY = 0;
        this.lineHeight = 0;
        this.texinfoMap = new HashMap();
        this.glyphTexinfos = new TextureInfo[this.font.getGlyphCount()];
        this.addAllGlyphsToTexture();
    }

    public boolean addTexture() {
        boolean resize;
        int h;
        int w = this.maxTexWidth;
        if (-1 < this.currentTex && this.textures[this.currentTex].glHeight < this.maxTexHeight) {
            h = PApplet.min((int)(2 * this.textures[this.currentTex].glHeight), (int)this.maxTexHeight);
            resize = true;
        } else {
            h = PApplet.min((int)512, (int)(this.maxTexHeight / 4));
            resize = false;
        }
        PTexture tex = new PTexture(this.parent, w, h, new PTexture.Parameters(2, 3));
        if (this.textures == null) {
            this.textures = new PTexture[1];
            this.textures[0] = tex;
            this.currentTex = 0;
        } else if (resize) {
            PTexture tex0 = this.textures[this.currentTex];
            tex.put(tex0);
            this.textures[this.currentTex] = tex;
            tex0.delete();
        } else {
            PTexture[] temp = this.textures;
            this.textures = new PTexture[this.textures.length + 1];
            PApplet.arrayCopy((Object)temp, (Object)this.textures, (int)temp.length);
            this.textures[temp.length] = tex;
            this.currentTex = this.textures.length - 1;
        }
        this.lastTex = this.currentTex;
        tex.bind();
        return resize;
    }

    public void setFirstTexture() {
        this.setTexture(0);
    }

    public void setTexture(int idx) {
        if (idx >= 0 && idx < this.textures.length) {
            this.currentTex = idx;
            this.textures[this.currentTex].bind();
        }
    }

    public void addAllGlyphsToTexture() {
        int i = 0;
        while (i < this.font.getGlyphCount()) {
            this.addToTexture(i, this.font.getGlyph(i));
            ++i;
        }
    }

    public void updateGlyphsTexCoords() {
        int i = 0;
        while (i < this.font.getGlyphCount()) {
            TextureInfo tinfo = this.glyphTexinfos[i];
            if (tinfo != null && tinfo.texIndex == this.currentTex) {
                tinfo.updateUV();
            }
            ++i;
        }
    }

    public TextureInfo getTexInfo(PFont.Glyph glyph) {
        TextureInfo info = this.texinfoMap.get(glyph);
        return info;
    }

    public TextureInfo addToTexture(PFont.Glyph glyph) {
        int n = this.glyphTexinfos.length;
        if (n == 0) {
            this.glyphTexinfos = new TextureInfo[1];
        }
        this.addToTexture(n, glyph);
        return this.glyphTexinfos[n];
    }

    protected void addToTexture(int idx, PFont.Glyph glyph) {
        int x;
        int y;
        int[] rgba = new int[glyph.width * glyph.height];
        int t = 0;
        int p = 0;
        if (PGraphicsOpenGL2.BIG_ENDIAN) {
            y = 0;
            while (y < glyph.height) {
                x = 0;
                while (x < glyph.width) {
                    rgba[t++] = 0xFFFFFF00 | glyph.image.pixels[p++];
                    ++x;
                }
                ++y;
            }
        } else {
            y = 0;
            while (y < glyph.height) {
                x = 0;
                while (x < glyph.width) {
                    rgba[t++] = glyph.image.pixels[p++] << 24 | 0xFFFFFF;
                    ++x;
                }
                ++y;
            }
        }
        if (this.offsetX + glyph.width > this.textures[this.currentTex].glWidth) {
            this.offsetX = 0;
            this.offsetY += this.lineHeight;
            this.lineHeight = 0;
        }
        this.lineHeight = Math.max(this.lineHeight, glyph.height);
        boolean resized = false;
        if (this.offsetY + this.lineHeight > this.textures[this.currentTex].glHeight) {
            resized = this.addTexture();
            if (resized) {
                this.updateGlyphsTexCoords();
            } else {
                this.offsetX = 0;
                this.offsetY = 0;
                this.lineHeight = 0;
            }
        }
        if (this.lastTex == -1) {
            this.lastTex = 0;
        }
        if (this.currentTex != this.lastTex || resized) {
            this.setTexture(this.lastTex);
        }
        this.textures[this.currentTex].setTexels(this.offsetX, this.offsetY, glyph.width, glyph.height, rgba);
        TextureInfo tinfo = new TextureInfo(this.currentTex, this.offsetX, this.offsetY + glyph.height, glyph.width, -glyph.height);
        this.offsetX += glyph.width;
        if (idx == this.glyphTexinfos.length) {
            TextureInfo[] temp = new TextureInfo[this.glyphTexinfos.length + 1];
            System.arraycopy(this.glyphTexinfos, 0, temp, 0, this.glyphTexinfos.length);
            this.glyphTexinfos = temp;
        }
        this.glyphTexinfos[idx] = tinfo;
        this.texinfoMap.put(glyph, tinfo);
    }

    public class TextureInfo {
        public int texIndex;
        public int[] crop;
        public float u0;
        public float u1;
        public float v0;
        public float v1;

        public TextureInfo(int tidx, int cropX, int cropY, int cropW, int cropH) {
            this.texIndex = tidx;
            this.crop = new int[4];
            this.crop[0] = cropX;
            this.crop[1] = cropY;
            this.crop[2] = cropW;
            this.crop[3] = cropH;
            this.u0 = (float)cropX / (float)PFontTexture.this.textures[tidx].glWidth;
            this.u1 = this.u0 + (float)cropW / (float)PFontTexture.this.textures[tidx].glWidth;
            this.v0 = (float)(cropY + cropH) / (float)PFontTexture.this.textures[tidx].glHeight;
            this.v1 = (float)cropY / (float)PFontTexture.this.textures[tidx].glHeight;
        }

        void updateUV() {
            this.u0 = (float)this.crop[0] / (float)PFontTexture.this.textures[this.texIndex].glWidth;
            this.u1 = this.u0 + (float)this.crop[2] / (float)PFontTexture.this.textures[this.texIndex].glWidth;
            this.v0 = (float)(this.crop[1] + this.crop[3]) / (float)PFontTexture.this.textures[this.texIndex].glHeight;
            this.v1 = (float)this.crop[1] / (float)PFontTexture.this.textures[this.texIndex].glHeight;
        }
    }
}

