/*
 * Decompiled with CFR 0.152.
 */
package JSci;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;

public final class Version
implements Serializable {
    public final int major;
    public final int minor;
    public final String platform;
    public final String home;

    public static Version getCurrent() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("JSci.Bundle");
        int n = Integer.parseInt(resourceBundle.getString("version.major"));
        int n2 = Integer.parseInt(resourceBundle.getString("version.minor"));
        String string = resourceBundle.getString("version.platform");
        String string2 = resourceBundle.getString("version.home");
        return new Version(n, n2, string2, string);
    }

    public static Version getLatest() throws IOException {
        Version version = null;
        try {
            URL uRL = new URL(Version.getCurrent().home + "version.ser");
            ObjectInputStream objectInputStream = new ObjectInputStream(uRL.openStream());
            version = (Version)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return version;
    }

    private Version(int n, int n2, String string, String string2) {
        this.major = n;
        this.minor = n2;
        this.home = string;
        this.platform = string2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return this.major == version.major && this.minor == version.minor && this.platform.equals(version.platform);
    }

    public int hashCode() {
        return 37 * (37 * (629 + this.major) + this.minor) + this.platform.hashCode();
    }

    public String toString() {
        return "" + this.major + '.' + this.minor;
    }

    public boolean isLater(Version version) {
        return this.major > version.major || this.major == version.major && this.minor > version.minor;
    }
}

