/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.groups;

import JSci.maths.Complex;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractComplexSquareMatrix;
import JSci.maths.matrices.ComplexDiagonalMatrix;
import JSci.maths.vectors.AbstractDoubleVector;

public class LieGroup {
    private AbstractComplexSquareMatrix[] generators;
    private AbstractComplexSquareMatrix identityMatrix;

    public LieGroup(AbstractComplexSquareMatrix[] abstractComplexSquareMatrixArray) {
        this.generators = abstractComplexSquareMatrixArray;
        this.identityMatrix = ComplexDiagonalMatrix.identity(this.generators[0].rows());
    }

    public final int dimension() {
        return this.generators.length;
    }

    public AbstractComplexSquareMatrix getElement(AbstractDoubleVector abstractDoubleVector) {
        if (this.generators.length != abstractDoubleVector.dimension()) {
            throw new IllegalArgumentException("The vector should match the generators.");
        }
        AbstractComplexMatrix abstractComplexMatrix = this.generators[0].scalarMultiply(abstractDoubleVector.getComponent(0));
        for (int i = 1; i < this.generators.length; ++i) {
            abstractComplexMatrix = abstractComplexMatrix.add(this.generators[i].scalarMultiply(abstractDoubleVector.getComponent(i)));
        }
        return (AbstractComplexSquareMatrix)this.identityMatrix.add(abstractComplexMatrix.scalarMultiply(Complex.I));
    }

    public AbstractComplexSquareMatrix identity() {
        return this.identityMatrix;
    }

    public final boolean isIdentity(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        return this.identityMatrix.equals(abstractComplexSquareMatrix);
    }

    public final boolean isInverse(AbstractComplexSquareMatrix abstractComplexSquareMatrix, AbstractComplexSquareMatrix abstractComplexSquareMatrix2) {
        return this.isIdentity(abstractComplexSquareMatrix.multiply(abstractComplexSquareMatrix2));
    }
}

