/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.maths.Complex;
import JSci.maths.fields.Field;
import JSci.maths.polynomials.ComplexPolynomial;
import JSci.maths.polynomials.ComplexPolynomialRing;
import JSci.maths.polynomials.Polynomial;
import JSci.maths.polynomials.PolynomialBasis;

public class ComplexLagrangeBasis
implements PolynomialBasis {
    private ComplexPolynomial[] _basis;
    private Complex[] _samplingsX;
    private int _dim;

    public ComplexLagrangeBasis(Field.Member[] memberArray) {
        if (memberArray == null) {
            throw new NullPointerException();
        }
        this._dim = memberArray.length;
        this._samplingsX = ComplexPolynomialRing.toComplex(memberArray);
        this.buildBasis();
    }

    public Polynomial getBasisVector(int n) {
        return this._basis[n];
    }

    public int dimension() {
        return this._dim;
    }

    public Field.Member[] getSamplingPoints() {
        return this._samplingsX;
    }

    public Polynomial superposition(Field.Member[] memberArray) {
        if (memberArray == null) {
            throw new NullPointerException();
        }
        if (memberArray.length != this._dim) {
            throw new IllegalArgumentException("Dimensions do not match");
        }
        Complex[] complexArray = ComplexPolynomialRing.toComplex(memberArray);
        return this.superposition(complexArray);
    }

    public ComplexPolynomial superposition(Complex[] complexArray) {
        if (complexArray == null) {
            throw new NullPointerException();
        }
        if (complexArray.length != this._dim) {
            throw new IllegalArgumentException("Dimension of basis is " + this._dim + ". Got " + complexArray.length + " coefficients");
        }
        ComplexPolynomial complexPolynomial = (ComplexPolynomial)ComplexPolynomialRing.getInstance().zero();
        for (int i = 0; i < this._dim; ++i) {
            ComplexPolynomial complexPolynomial2 = (ComplexPolynomial)this.getBasisVector(i);
            ComplexPolynomial complexPolynomial3 = complexPolynomial2.scalarMultiply(complexArray[i]);
            complexPolynomial = (ComplexPolynomial)complexPolynomial.add(complexPolynomial3);
        }
        return complexPolynomial;
    }

    private void buildBasis() {
        this._basis = new ComplexPolynomial[this._dim];
        for (int i = 0; i < this._dim; ++i) {
            this._basis[i] = (ComplexPolynomial)ComplexPolynomialRing.getInstance().one();
            Complex complex = Complex.ONE;
            for (int j = 0; j < this._dim; ++j) {
                if (j == i) continue;
                ComplexPolynomial complexPolynomial = new ComplexPolynomial(new Complex[]{(Complex)this._samplingsX[j].negate(), Complex.ONE});
                this._basis[i] = (ComplexPolynomial)this._basis[i].multiply(complexPolynomial);
                Complex complex2 = this._samplingsX[i];
                Complex complex3 = this._samplingsX[j];
                Complex complex4 = complex2.subtract(complex3);
                complex = complex.multiply(complex4);
            }
            this._basis[i] = this._basis[i].scalarDivide(complex);
        }
    }
}

