/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.maths.AbstractMath;
import JSci.maths.Complex;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractComplexSquareMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.polynomials.ComplexLagrangeBasis;
import JSci.maths.polynomials.ComplexPolynomial;
import JSci.maths.polynomials.Polynomial;
import JSci.maths.polynomials.RealLagrangeBasis;
import JSci.maths.polynomials.RealPolynomial;

public final class PolynomialMath
extends AbstractMath {
    private PolynomialMath() {
    }

    public static AbstractDoubleSquareMatrix toCompanionMatrix(RealPolynomial realPolynomial) {
        RealPolynomial realPolynomial2 = PolynomialMath.normalize(realPolynomial);
        int n = realPolynomial2.degree();
        if (n < 1) {
            throw new IllegalArgumentException("Cannot get a companion matrix for a constant factor");
        }
        DoubleSquareMatrix doubleSquareMatrix = new DoubleSquareMatrix(n);
        for (int i = 0; i < n - 1; ++i) {
            ((AbstractDoubleMatrix)doubleSquareMatrix).setElement(i + 1, i, 1.0);
            ((AbstractDoubleMatrix)doubleSquareMatrix).setElement(i, n - 1, realPolynomial2.getCoefficientAsDouble(i));
        }
        ((AbstractDoubleMatrix)doubleSquareMatrix).setElement(n - 1, n - 1, realPolynomial2.getCoefficientAsDouble(n - 1));
        return doubleSquareMatrix;
    }

    public static AbstractComplexSquareMatrix toCompanionMatrix(ComplexPolynomial complexPolynomial) {
        ComplexPolynomial complexPolynomial2 = PolynomialMath.normalize(complexPolynomial);
        int n = complexPolynomial2.degree();
        if (n < 1) {
            throw new IllegalArgumentException("Cannot get a companion matrix for a constant factor");
        }
        ComplexSquareMatrix complexSquareMatrix = new ComplexSquareMatrix(n);
        for (int i = 0; i < n - 1; ++i) {
            ((AbstractComplexMatrix)complexSquareMatrix).setElement(i + 1, i, 1.0, 0.0);
            ((AbstractComplexMatrix)complexSquareMatrix).setElement(i, n - 1, complexPolynomial2.getCoefficientAsComplex(i));
        }
        ((AbstractComplexMatrix)complexSquareMatrix).setElement(n - 1, n - 1, complexPolynomial2.getCoefficientAsComplex(n - 1));
        return complexSquareMatrix;
    }

    public static Complex[] findRoots(RealPolynomial realPolynomial) {
        AbstractDoubleSquareMatrix abstractDoubleSquareMatrix = PolynomialMath.toCompanionMatrix(realPolynomial);
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public static int maxDegree(Polynomial polynomial, Polynomial polynomial2) {
        return Math.max(polynomial.degree(), polynomial2.degree());
    }

    public static int minDegree(Polynomial polynomial, Polynomial polynomial2) {
        return Math.min(polynomial.degree(), polynomial2.degree());
    }

    public static double evalPolynomial(RealPolynomial realPolynomial, double d) {
        int n = realPolynomial.degree();
        double d2 = realPolynomial.getCoefficientAsDouble(n);
        for (int i = n - 1; i >= 0; --i) {
            d2 = realPolynomial.getCoefficientAsDouble(i) + d2 * d;
        }
        return d2;
    }

    public static Complex evalPolynomial(ComplexPolynomial complexPolynomial, Complex complex) {
        int n = complexPolynomial.degree();
        Complex complex2 = complexPolynomial.getCoefficientAsComplex(n);
        for (int i = n - 1; i >= 0; --i) {
            complex2 = complexPolynomial.getCoefficientAsComplex(i).add(complex2.multiply(complex));
        }
        return complex2;
    }

    public static RealPolynomial interpolateLagrange(double[][] dArray) {
        RealLagrangeBasis realLagrangeBasis = new RealLagrangeBasis(dArray[0]);
        return realLagrangeBasis.superposition(dArray[1]);
    }

    public static ComplexPolynomial interpolateLagrange(Complex[][] complexArray) {
        ComplexLagrangeBasis complexLagrangeBasis = new ComplexLagrangeBasis(complexArray[0]);
        return complexLagrangeBasis.superposition(complexArray[1]);
    }

    public static RealPolynomial normalize(RealPolynomial realPolynomial) {
        int n = realPolynomial.degree();
        double d = realPolynomial.getCoefficientAsDouble(n);
        double[] dArray = new double[n + 1];
        dArray[n] = 1.0;
        for (int i = 0; i < n; ++i) {
            dArray[i] = realPolynomial.getCoefficientAsDouble(i) / d;
        }
        return new RealPolynomial(dArray);
    }

    public static ComplexPolynomial normalize(ComplexPolynomial complexPolynomial) {
        int n = complexPolynomial.degree();
        Complex complex = complexPolynomial.getCoefficientAsComplex(n);
        Complex[] complexArray = new Complex[n + 1];
        complexArray[n] = Complex.ONE;
        for (int i = 0; i < n; ++i) {
            complexArray[i] = complexPolynomial.getCoefficientAsComplex(i).divide(complex);
        }
        return new ComplexPolynomial(complexArray);
    }

    public static ComplexPolynomial toComplex(Polynomial polynomial) {
        if (polynomial instanceof ComplexPolynomial) {
            return (ComplexPolynomial)polynomial;
        }
        if (polynomial instanceof RealPolynomial) {
            double[] dArray = ((RealPolynomial)polynomial).getCoefficientsAsDoubles();
            Complex[] complexArray = new Complex[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                complexArray[i] = new Complex(dArray[i], 0.0);
            }
            return new ComplexPolynomial(complexArray);
        }
        throw new IllegalArgumentException("Polynomial class not recognised by this method.");
    }
}

