/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.symbolic;

import JSci.maths.Complex;
import JSci.maths.MathDouble;
import JSci.maths.fields.Ring;
import JSci.maths.symbolic.Constant;
import JSci.maths.symbolic.Expression;
import JSci.maths.symbolic.Variable;

public class Function
extends Expression {
    public static final String SIN = "sin";
    public static final String COS = "cos";
    public static final String TAN = "tan";
    public static final String ASIN = "asin";
    public static final String ACOS = "acos";
    public static final String ATAN = "atan";
    public static final String SINH = "sinh";
    public static final String COSH = "cosh";
    public static final String TANH = "tanh";
    public static final String ASINH = "asinh";
    public static final String ACOSH = "acosh";
    public static final String ATANH = "atanh";
    public static final String EXP = "exp";
    public static final String LOG = "log";
    public static final String SQRT = "sqrt";
    private final String type;
    private final Expression arg;
    static /* synthetic */ Class class$JSci$maths$symbolic$Function;

    public Function(String string, Expression expression) {
        this.type = string;
        this.arg = expression;
    }

    public String toString() {
        return this.type + "(" + this.arg + ")";
    }

    public int getPriority() {
        return 15;
    }

    public Expression differentiate(Variable variable) {
        Expression expression = null;
        if (this.type.equals(SIN)) {
            expression = new Function(COS, this.arg);
        }
        if (this.type.equals(COS)) {
            expression = Expression.negative(new Function(SIN, this.arg));
        }
        if (this.type.equals(TAN)) {
            expression = Expression.power(new Function(COS, this.arg), -2);
        }
        if (this.type.equals(ASIN)) {
            expression = Expression.inverse(new Function(SQRT, Expression.sum(((Ring)this.getSet()).one(), Expression.negative(Expression.power(this.arg, 2)))));
        }
        if (this.type.equals(ACOS)) {
            expression = Expression.inverse(new Function(SQRT, Expression.sum(((Ring)this.getSet()).one(), Expression.negative(Expression.power(this.arg, 2)))));
        }
        if (this.type.equals(ATAN)) {
            expression = Expression.inverse(Expression.sum(((Ring)this.getSet()).one(), Expression.power(this.arg, 2)));
        }
        if (this.type.equals(SINH)) {
            expression = new Function(COSH, this.arg);
        }
        if (this.type.equals(COSH)) {
            expression = new Function(SINH, this.arg);
        }
        if (this.type.equals(TANH)) {
            expression = Expression.power(new Function(COSH, this.arg), -2);
        }
        if (this.type.equals(ASINH)) {
            expression = Expression.inverse(new Function(SQRT, Expression.sum(((Ring)this.getSet()).one(), Expression.power(this.arg, 2))));
        }
        if (this.type.equals(ACOSH)) {
            expression = Expression.inverse(new Function(SQRT, Expression.sum(((Ring)this.getSet()).one().negate(), Expression.power(this.arg, 2))));
        }
        if (this.type.equals(ATANH)) {
            expression = Expression.inverse(new Function(SQRT, Expression.sum(((Ring)this.getSet()).one(), Expression.power(this.arg, 2).negate())));
        }
        if (this.type.equals(EXP)) {
            expression = new Function(EXP, this.arg);
        }
        if (this.type.equals(LOG)) {
            expression = Expression.inverse(this.arg);
        }
        if (this.type.equals(SQRT)) {
            expression = Expression.inverse(Expression.product((Ring.Member)((Ring)this.getSet()).one().add(((Ring)this.getSet()).one()), new Function(SQRT, this.arg)));
        }
        if (expression == null) {
            throw new IllegalArgumentException("Unknown Function type in derivative()");
        }
        return Expression.product(expression, this.arg.differentiate(variable));
    }

    public boolean equals(Object object) {
        if (!(class$JSci$maths$symbolic$Function == null ? (class$JSci$maths$symbolic$Function = Function.class$("JSci.maths.symbolic.Function")) : class$JSci$maths$symbolic$Function).isInstance(object)) {
            return false;
        }
        Function function = (Function)object;
        return this.type.equals(function.type) && this.arg.equals(function.arg);
    }

    public Object getSet() {
        return this.arg.getSet();
    }

    public Expression evaluate() {
        Expression expression = this.arg.evaluate();
        if (expression instanceof Constant) {
            if (((Constant)expression).getValue() instanceof Complex) {
                Complex complex = (Complex)((Constant)expression).getValue();
                if (this.type.equals(SIN)) {
                    return new Constant(Complex.sin(complex));
                }
                if (this.type.equals(COS)) {
                    return new Constant(Complex.cos(complex));
                }
                if (this.type.equals(TAN)) {
                    return new Constant(Complex.tan(complex));
                }
                if (this.type.equals(ASIN)) {
                    return new Constant(Complex.asin(complex));
                }
                if (this.type.equals(ACOS)) {
                    return new Constant(Complex.acos(complex));
                }
                if (this.type.equals(ATAN)) {
                    return new Constant(Complex.atan(complex));
                }
                if (this.type.equals(SIN)) {
                    return new Constant(Complex.sinh(complex));
                }
                if (this.type.equals(COS)) {
                    return new Constant(Complex.cosh(complex));
                }
                if (this.type.equals(TAN)) {
                    return new Constant(Complex.tanh(complex));
                }
                if (this.type.equals(ASIN)) {
                    return new Constant(Complex.asinh(complex));
                }
                if (this.type.equals(ACOS)) {
                    return new Constant(Complex.acosh(complex));
                }
                if (this.type.equals(ATAN)) {
                    return new Constant(Complex.atanh(complex));
                }
                if (this.type.equals(EXP)) {
                    return new Constant(Complex.exp(complex));
                }
                if (this.type.equals(LOG)) {
                    return new Constant(Complex.log(complex));
                }
                if (this.type.equals(SQRT)) {
                    return new Constant(complex.sqrt());
                }
                throw new IllegalArgumentException("Unknown Function type in evaluate()");
            }
            if (((Constant)expression).getValue() instanceof MathDouble) {
                MathDouble mathDouble = (MathDouble)((Constant)expression).getValue();
                if (this.type.equals(SIN)) {
                    return new Constant(MathDouble.sin(mathDouble));
                }
                if (this.type.equals(COS)) {
                    return new Constant(MathDouble.cos(mathDouble));
                }
                if (this.type.equals(TAN)) {
                    return new Constant(MathDouble.tan(mathDouble));
                }
                if (this.type.equals(ASIN)) {
                    return new Constant(MathDouble.asin(mathDouble));
                }
                if (this.type.equals(ACOS)) {
                    return new Constant(MathDouble.acos(mathDouble));
                }
                if (this.type.equals(ATAN)) {
                    return new Constant(MathDouble.atan(mathDouble));
                }
                if (this.type.equals(SIN)) {
                    return new Constant(MathDouble.sinh(mathDouble));
                }
                if (this.type.equals(COS)) {
                    return new Constant(MathDouble.cosh(mathDouble));
                }
                if (this.type.equals(TAN)) {
                    return new Constant(MathDouble.tanh(mathDouble));
                }
                if (this.type.equals(ASIN)) {
                    return new Constant(MathDouble.asinh(mathDouble));
                }
                if (this.type.equals(ACOS)) {
                    return new Constant(MathDouble.acosh(mathDouble));
                }
                if (this.type.equals(ATAN)) {
                    return new Constant(MathDouble.atanh(mathDouble));
                }
                if (this.type.equals(EXP)) {
                    return new Constant(MathDouble.exp(mathDouble));
                }
                if (this.type.equals(LOG)) {
                    return new Constant(MathDouble.log(mathDouble));
                }
                if (this.type.equals(SQRT)) {
                    return new Constant(new MathDouble(Math.sqrt(mathDouble.value())));
                }
                throw new IllegalArgumentException("Unknown Function type in evaluate()");
            }
            throw new IllegalArgumentException("Function argument is " + expression.getSet() + " ; must be Complex or MathDouble");
        }
        if (expression instanceof Function) {
            Function function = (Function)expression;
            if (this.type.equals(SIN) && function.type.equals(ASIN)) {
                return function.arg;
            }
            if (this.type.equals(COS) && function.type.equals(ACOS)) {
                return function.arg;
            }
            if (this.type.equals(TAN) && function.type.equals(ATAN)) {
                return function.arg;
            }
            if (this.type.equals(ASIN) && function.type.equals(SIN)) {
                return function.arg;
            }
            if (this.type.equals(ACOS) && function.type.equals(COS)) {
                return function.arg;
            }
            if (this.type.equals(ATAN) && function.type.equals(TAN)) {
                return function.arg;
            }
            if (this.type.equals(SINH) && function.type.equals(ASINH)) {
                return function.arg;
            }
            if (this.type.equals(COSH) && function.type.equals(ACOSH)) {
                return function.arg;
            }
            if (this.type.equals(TANH) && function.type.equals(ATANH)) {
                return function.arg;
            }
            if (this.type.equals(ASINH) && function.type.equals(SINH)) {
                return function.arg;
            }
            if (this.type.equals(ACOSH) && function.type.equals(COSH)) {
                return function.arg;
            }
            if (this.type.equals(ATANH) && function.type.equals(TANH)) {
                return function.arg;
            }
            if (this.type.equals(EXP) && function.type.equals(LOG)) {
                return function.arg;
            }
            if (this.type.equals(LOG) && function.type.equals(EXP)) {
                return function.arg;
            }
        }
        return new Function(this.type, expression);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

