/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.maths.MathInteger;
import JSci.maths.algebras.Module;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.maths.vectors.Complex2Vector;
import JSci.maths.vectors.Double2Vector;
import JSci.maths.vectors.VectorDimensionException;

public final class Integer2Vector
extends AbstractIntegerVector {
    protected int x;
    protected int y;

    public Integer2Vector() {
        super(2);
    }

    public Integer2Vector(int n, int n2) {
        this();
        this.x = n;
        this.y = n2;
    }

    public Integer2Vector(int[] nArray) {
        this();
        this.x = nArray[0];
        this.y = nArray[1];
    }

    public boolean equals(Object object, double d) {
        if (object != null && object instanceof Integer2Vector) {
            Integer2Vector integer2Vector = (Integer2Vector)object;
            int n = this.x - integer2Vector.x;
            int n2 = this.y - integer2Vector.y;
            return n * n + n2 * n2 == 0;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(this.x).append(',').append(this.y);
        return stringBuffer.toString();
    }

    public AbstractDoubleVector toDoubleVector() {
        return new Double2Vector(this.x, this.y);
    }

    public AbstractComplexVector toComplexVector() {
        return new Complex2Vector(this.x, 0.0, this.y, 0.0);
    }

    public int getComponent(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public void setComponent(int n, int n2) {
        switch (n) {
            case 0: {
                this.x = n2;
                break;
            }
            case 1: {
                this.y = n2;
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    public double norm(int n) {
        double d = Math.pow(Math.abs(this.x), n) + Math.pow(Math.abs(this.y), n);
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double infNorm() {
        int n = 0;
        int n2 = Math.abs(this.x);
        if (n2 > n) {
            n = n2;
        }
        if ((n2 = Math.abs(this.y)) > n) {
            n = n2;
        }
        return n;
    }

    public AbelianGroup.Member negate() {
        return new Integer2Vector(-this.x, -this.y);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractIntegerVector) {
            return this.add((AbstractIntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerVector add(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector.N == 2) {
            return new Integer2Vector(this.x + abstractIntegerVector.getComponent(0), this.y + abstractIntegerVector.getComponent(1));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractIntegerVector) {
            return this.subtract((AbstractIntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerVector subtract(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector.N == 2) {
            return new Integer2Vector(this.x - abstractIntegerVector.getComponent(0), this.y - abstractIntegerVector.getComponent(1));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerVector scalarMultiply(int n) {
        return new Integer2Vector(n * this.x, n * this.y);
    }

    public int scalarProduct(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector.N == 2) {
            return this.x * abstractIntegerVector.getComponent(0) + this.y * abstractIntegerVector.getComponent(1);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }
}

