/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.AbstractPackMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTriangPackMatrix
extends AbstractPackMatrix {
    UpLo uplo;
    Diag diag;

    AbstractTriangPackMatrix(int n, UpLo uplo, Diag diag) {
        super(n);
        this.uplo = uplo;
        this.diag = diag;
    }

    AbstractTriangPackMatrix(Matrix A, UpLo uplo, Diag diag) {
        this(A, false, uplo, diag);
    }

    AbstractTriangPackMatrix(Matrix A, boolean deep, UpLo uplo, Diag diag) {
        super(A, deep);
        this.uplo = uplo;
        this.diag = diag;
    }

    @Override
    public Vector mult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.mult(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        BLAS.getInstance().dtpmv(this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.diag.netlib(), this.numRows, this.data, yd, 1);
        return y;
    }

    @Override
    public Vector transMult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.transMult(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        BLAS.getInstance().dtpmv(this.uplo.netlib(), Transpose.Transpose.netlib(), this.diag.netlib(), this.numRows, this.data, yd, 1);
        return y;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X) {
        return this.solve(B, X, Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X) {
        return this.solve(B, X, Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.transSolve(B, X);
        return x;
    }

    Matrix solve(Matrix B, Matrix X, Transpose trans) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        intW info = new intW(0);
        LAPACK.getInstance().dtptrs(this.uplo.netlib(), trans.netlib(), this.diag.netlib(), this.numRows, X.numColumns(), this.data, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new TriangPackMatrixIterator();
    }

    private class TriangPackMatrixIterator
    extends AbstractMatrix.RefMatrixIterator {
        private TriangPackMatrixIterator() {
        }

        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (AbstractTriangPackMatrix.this.uplo == UpLo.Lower) {
                if (this.row < AbstractTriangPackMatrix.this.numRows - 1) {
                    ++this.row;
                } else {
                    ++this.column;
                    this.row = this.column;
                }
            } else if (this.row < this.column) {
                ++this.row;
            } else {
                ++this.column;
                this.row = 0;
            }
            return this.entry;
        }
    }
}

