/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.OrthogonalComputer;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class RQ
extends OrthogonalComputer {
    public RQ(int m, int n) {
        super(m, n, true);
        if (n < m) {
            throw new IllegalArgumentException("n < m");
        }
        this.work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgerqf(m, n, new double[0], Matrices.ld(m), new double[0], this.work, -1, info);
        int lwork = info.val != 0 ? m : (int)this.work[0];
        lwork = Math.max(1, lwork);
        this.work = new double[lwork];
        this.workGen = new double[1];
        info = new intW(0);
        LAPACK.getInstance().dorgrq(m, n, m, new double[0], Matrices.ld(m), new double[0], this.workGen, -1, info);
        lwork = info.val != 0 ? m : (int)this.workGen[0];
        lwork = Math.max(1, lwork);
        this.workGen = new double[lwork];
    }

    public static RQ factorize(Matrix A) {
        return new RQ(A.numRows(), A.numColumns()).factor(new DenseMatrix(A));
    }

    public RQ factor(DenseMatrix A) {
        if (this.Q.numRows() != A.numRows()) {
            throw new IllegalArgumentException("Q.numRows() != A.numRows()");
        }
        if (this.Q.numColumns() != A.numColumns()) {
            throw new IllegalArgumentException("Q.numColumns() != A.numColumns()");
        }
        if (this.R == null) {
            throw new IllegalArgumentException("R == null");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgerqf(this.m, this.n, A.getData(), Matrices.ld(this.m), this.tau, this.work, this.work.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.R.zero();
        for (MatrixEntry e : A) {
            if (e.column() < this.n - this.m + e.row()) continue;
            this.R.set(e.row(), e.column() - (this.n - this.m), e.get());
        }
        info.val = 0;
        LAPACK.getInstance().dorgrq(this.m, this.n, this.k, A.getData(), Matrices.ld(this.m), this.tau, this.workGen, this.workGen.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.Q.set(A);
        return this;
    }

    public UpperTriangDenseMatrix getR() {
        return this.R;
    }
}

