/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.Receiver;
import ptolemy.actor.util.Time;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;

public abstract class AbstractReceiver
implements Receiver {
    private IOPort _container;
    private Token[] _tokenCache;

    public AbstractReceiver() {
    }

    public AbstractReceiver(IOPort container) throws IllegalActionException {
        this.setContainer(container);
    }

    @Override
    public void clear() throws IllegalActionException {
        throw new IllegalActionException((Nameable)this.getContainer(), "Receiver class " + this.getClass().getName() + " does not support clear().");
    }

    @Override
    public abstract Token get() throws NoTokenException;

    @Override
    public Token[] getArray(int numberOfTokens) throws NoTokenException {
        if (this._tokenCache == null || numberOfTokens != this._tokenCache.length) {
            this._tokenCache = new Token[numberOfTokens];
        }
        for (int i = 0; i < numberOfTokens; ++i) {
            this._tokenCache[i] = this.get();
        }
        return this._tokenCache;
    }

    @Override
    public IOPort getContainer() {
        return this._container;
    }

    public double getCurrentTime() {
        return this.getModelTime().getDoubleValue();
    }

    public Time getModelTime() {
        IOPort containerPort = this.getContainer();
        Actor containerActor = (Actor)((Object)containerPort.getContainer());
        Director containerDirector = containerActor.getDirector();
        return containerDirector.getModelTime();
    }

    @Override
    public abstract boolean hasRoom();

    @Override
    public abstract boolean hasRoom(int var1);

    @Override
    public abstract boolean hasToken();

    @Override
    public abstract boolean hasToken(int var1);

    @Override
    public boolean isKnown() {
        return true;
    }

    @Override
    public abstract void put(Token var1) throws NoRoomException, IllegalActionException;

    @Override
    public void putArray(Token[] tokenArray, int numberOfTokens) throws NoRoomException, IllegalActionException {
        IOPort container = this.getContainer();
        if (container == null) {
            for (int i = 0; i < numberOfTokens; ++i) {
                this.put(tokenArray[i]);
            }
        } else {
            for (int i = 0; i < numberOfTokens; ++i) {
                this.put(container.convert(tokenArray[i]));
            }
        }
    }

    @Override
    public void putArrayToAll(Token[] tokens, int numberOfTokens, Receiver[] receivers) throws NoRoomException, IllegalActionException {
        if (numberOfTokens > tokens.length) {
            IOPort container = this.getContainer();
            throw new IllegalActionException((Nameable)container, "Not enough tokens supplied.");
        }
        for (int j = 0; j < receivers.length; ++j) {
            receivers[j].putArray(tokens, numberOfTokens);
        }
    }

    @Override
    public void putToAll(Token token, Receiver[] receivers) throws NoRoomException, IllegalActionException {
        for (int j = 0; j < receivers.length; ++j) {
            IOPort container = receivers[j].getContainer();
            if (container == null) {
                receivers[j].put(token);
                continue;
            }
            receivers[j].put(container.convert(token));
        }
    }

    @Override
    public void reset() throws IllegalActionException {
        this.clear();
    }

    @Override
    public void setContainer(IOPort port) throws IllegalActionException {
        this._container = port;
    }

    public String toString() {
        return this.getClass().getName() + " {" + this.getContainer().getFullName() + ".receiver }";
    }
}

