/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.kernel.util.DebugEvent;
import ptolemy.kernel.util.NamedObj;

public class FiringEvent
implements DebugEvent {
    public static final FiringEventType AFTER_PREFIRE = new FiringEventType("prefired", false);
    public static final FiringEventType AFTER_FIRE = new FiringEventType("fired", false);
    public static final FiringEventType AFTER_POSTFIRE = new FiringEventType("postfired", false);
    public static final FiringEventType AFTER_ITERATE = new FiringEventType("iterated", false);
    public static final FiringEventType BEFORE_PREFIRE = new FiringEventType("prefired", true);
    public static final FiringEventType BEFORE_FIRE = new FiringEventType("fired", true);
    public static final FiringEventType BEFORE_POSTFIRE = new FiringEventType("postfired", true);
    public static final FiringEventType BEFORE_ITERATE = new FiringEventType("iterated", true);
    public static final FiringEventType BEFORE_RW_FIRE = new FiringEventType("rw fired", true);
    public static final FiringEventType AFTER_RW_FIRE = new FiringEventType("rw fired", false);
    private Actor _actor;
    private Director _director;
    private int _multiplicity = 1;
    private FiringEventType _type;

    public FiringEvent(Director source, Actor actor, FiringEventType type) {
        this._director = source;
        this._actor = actor;
        this._type = type;
    }

    public FiringEvent(Director source, Actor actor, FiringEventType type, int multiplicity) {
        this._director = source;
        this._actor = actor;
        this._type = type;
        this._multiplicity = multiplicity;
    }

    public Actor getActor() {
        return this._actor;
    }

    public Director getDirector() {
        return this._director;
    }

    @Override
    public NamedObj getSource() {
        return this._director;
    }

    public FiringEventType getType() {
        return this._type;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("The actor ");
        buffer.append(((NamedObj)((Object)this._actor)).getFullName());
        buffer.append(" ");
        buffer.append(this._type.getName());
        if (this._multiplicity > 1) {
            buffer.append(" ");
            buffer.append(this._multiplicity);
            buffer.append(" times");
        }
        buffer.append(".");
        return buffer.toString();
    }

    public static class FiringEventType {
        private String _name;
        private boolean _isStart;

        private FiringEventType(String name, boolean isStart) {
            this._isStart = isStart;
            this._name = name;
        }

        public String getName() {
            if (this._isStart) {
                return "will be " + this._name;
            }
            return "was " + this._name;
        }

        public String toString() {
            return "FiringEventType(" + this.getName() + ")";
        }

        public boolean isStart() {
            return this._isStart;
        }

        public String getTypeName() {
            return this._name;
        }
    }
}

