/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import ptolemy.actor.IOPort;
import ptolemy.data.Token;
import ptolemy.kernel.util.DebugEvent;
import ptolemy.kernel.util.NamedObj;

public class IOPortEvent
implements DebugEvent {
    public static final int SEND = 1;
    public static final int GET_BEGIN = 2;
    public static final int GET_END = 3;
    public static final int ALLCHANNELS = -1;
    public static final int SINGLETOKEN = -1;
    private int _channel;
    private IOPort _port;
    private int _event;
    private boolean _outside;
    private Token _token;
    private Token[] _tokenArray;
    private int _vectorLength;

    public IOPortEvent(IOPort port, int event, int channel, boolean outside, Token[] tokens, int vectorLength) {
        this._port = port;
        this._event = event;
        this._channel = channel;
        this._outside = outside;
        this._tokenArray = tokens;
        this._token = null;
        this._vectorLength = vectorLength;
    }

    public IOPortEvent(IOPort port, int event, int channel, boolean outside, Token token) {
        this._port = port;
        this._event = event;
        this._channel = channel;
        this._outside = outside;
        this._tokenArray = null;
        this._token = token;
        this._vectorLength = -1;
    }

    @Override
    public NamedObj getSource() {
        return this._port;
    }

    public int getChannel() {
        return this._channel;
    }

    public int getEventType() {
        return this._event;
    }

    public boolean getOutsideFlag() {
        return this._outside;
    }

    public IOPort getPort() {
        return this._port;
    }

    public Token getToken() {
        return this._token;
    }

    public Token[] getTokenArray() {
        return this._tokenArray;
    }

    public int getVectorLength() {
        return this._vectorLength;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer("The port " + this._port + " sent ");
        if (this._vectorLength != -1) {
            buffer.append(this._vectorLength);
            buffer.append(" tokens ");
        } else {
            buffer.append(this._token.toString());
        }
        if (this._channel != -1) {
            buffer.append(" to channel " + this._channel + ".");
        } else {
            buffer.append(" to all channels");
        }
        return buffer.toString();
    }
}

