/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.io.OutputStream;
import java.io.PrintStream;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;

public class StreamExecutionListener
implements ExecutionListener {
    private PrintStream _output;

    public StreamExecutionListener() {
        this._output = System.out;
    }

    public StreamExecutionListener(OutputStream out) {
        this._output = new PrintStream(out);
    }

    @Override
    public void executionError(Manager manager, Throwable throwable) {
        this._output.println("Execution error.");
        throwable.printStackTrace(this._output);
    }

    @Override
    public void executionFinished(Manager manager) {
        this._output.println("Completed execution with " + manager.getIterationCount() + " iterations");
    }

    @Override
    public void managerStateChanged(Manager manager) {
        Manager.State state = manager.getState();
        String message = state == Manager.ITERATING ? state.getDescription() + " number " + manager.getIterationCount() : state.getDescription();
        this._output.println(message);
    }
}

