/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URI;
import javax.swing.JFrame;
import ptolemy.actor.gt.LocationType;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.lib.Sink;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ActorToken;
import ptolemy.data.IntToken;
import ptolemy.data.RecordToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.moml.MoMLParser;

public class ModelView
extends Sink
implements WindowListener {
    public Parameter screenLocation;
    public PortParameter title;
    private MoMLParser _parser = new MoMLParser();
    private Tableau[] _tableaus;

    public ModelView(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(ActorToken.TYPE);
        this.title = new PortParameter(this, "title");
        this.title.setStringMode(true);
        this.title.setExpression("");
        Parameter NONE = new Parameter(this, "NONE");
        NONE.setToken("{x=-1, y=-1}");
        NONE.setVisibility(Settable.EXPERT);
        this.screenLocation = new Parameter(this, "screenLocation");
        this.screenLocation.setTypeAtMost(LocationType.LOCATION);
        this.screenLocation.setToken("NONE");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ModelView actor = (ModelView)super.clone();
        actor._parser = new MoMLParser();
        return actor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.title.update();
        String titleValue = ((StringToken)this.title.getToken()).stringValue();
        for (int i = 0; i < this.input.getWidth(); ++i) {
            if (!this.input.hasToken(i)) continue;
            ModelView modelView = this;
            synchronized (modelView) {
                Entity model = ((ActorToken)this.input.get(0)).getEntity();
                Effigy effigy = Configuration.findEffigy(this.toplevel());
                Configuration configuration = (Configuration)effigy.toplevel();
                try {
                    this._parser.reset();
                    NamedObj newModel = this._parser.parse(model.exportMoML());
                    Tableau tableau = configuration.openModel(newModel, effigy);
                    if (this._tableaus[i] != null) {
                        this._tableaus[i].close();
                    }
                    this._tableaus[i] = tableau;
                    JFrame frame = tableau.getFrame();
                    RecordToken location = (RecordToken)this.screenLocation.getToken();
                    int x = ((IntToken)location.get("x")).intValue();
                    int y = ((IntToken)location.get("y")).intValue();
                    Point newLocation = frame.getLocation();
                    if (x >= 0) {
                        newLocation.x = x;
                    }
                    if (y >= 0) {
                        newLocation.y = y;
                    }
                    Dimension size = frame.getSize();
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Dimension screenSize = toolkit.getScreenSize();
                    newLocation.x = Math.min(newLocation.x, screenSize.width - size.width);
                    newLocation.y = Math.min(newLocation.y, screenSize.height - size.height);
                    frame.setLocation(newLocation);
                    frame.addWindowListener(this);
                    String titleString = null;
                    if (titleValue.equals("")) {
                        URI uri = URIAttribute.getModelURI(newModel);
                        if (uri != null) {
                            URI modelURI = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath() + newModel.getName() + ".xml", null, null);
                            titleString = modelURI.toString() + " (" + this.getName() + ")";
                        }
                    } else {
                        titleString = titleValue;
                    }
                    tableau.setTitle(titleString);
                }
                catch (NameDuplicationException e) {
                    throw new IllegalActionException((Nameable)this, e, "Cannot open model.");
                }
                catch (Exception e) {
                    throw new IllegalActionException((Nameable)this, e, "Cannot parse model.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        ModelView modelView = this;
        synchronized (modelView) {
            if (this._tableaus != null) {
                for (Tableau tableau : this._tableaus) {
                    if (tableau == null) continue;
                    tableau.close();
                }
            }
            this._tableaus = new Tableau[this.input.getWidth()];
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public synchronized void windowClosed(WindowEvent e) {
        Window window = (Window)e.getSource();
        if (this._tableaus != null) {
            for (int i = 0; i < this._tableaus.length; ++i) {
                JFrame frame;
                if (this._tableaus[i] == null || (frame = this._tableaus[i].getFrame()) != window) continue;
                frame.removeWindowListener(this);
                this._tableaus[i] = null;
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

