/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gt.GTIngredientList;
import ptolemy.actor.gt.GTIngredientsAttribute;
import ptolemy.actor.gt.ingredients.criteria.PortCriterion;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.StringUtilities;

public class PortMatcher
extends TypedIOPort {
    private PortCriterion _criterion;

    public PortMatcher(PortCriterion criterion, ComponentEntity container, String name, boolean isInput, boolean isOutput) throws IllegalActionException, NameDuplicationException {
        super(container, name, isInput, isOutput);
        this._criterion = criterion;
    }

    public PortCriterion getPortCriterion() {
        return this._criterion;
    }

    @Override
    public void setContainer(Entity container) throws IllegalActionException, NameDuplicationException {
        if (container == null && this._criterion != null) {
            GTIngredientList list = this._criterion.getOwner();
            GTIngredientsAttribute attribute = list.getOwner();
            GTIngredientList newList = new GTIngredientList(attribute, list);
            newList.remove(this._criterion);
            String moml = "<property name=\"" + attribute.getName() + "\" value=\"" + StringUtilities.escapeForXML(newList.toString()) + "\"/>";
            MoMLChangeRequest request = new MoMLChangeRequest(this, this.getContainer(), moml);
            request.setUndoable(true);
            attribute.requestChange(request);
            this._criterion = null;
        } else {
            super.setContainer(container);
        }
    }

    protected void _setPortCriterion(PortCriterion criterion) {
        this._criterion = criterion;
    }
}

