/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt.data;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import ptolemy.actor.gt.data.TwoWayHashMap;
import ptolemy.kernel.util.NamedObj;

public class MatchResult
extends TwoWayHashMap<Object, Object> {
    private List<Object> _keySequence = new LinkedList<Object>();

    @Override
    public void clear() {
        super.clear();
        this._keySequence.clear();
    }

    @Override
    public Object clone() {
        MatchResult result = (MatchResult)super.clone();
        result._keySequence = new LinkedList<Object>(this._keySequence);
        return result;
    }

    @Override
    public Object put(Object key, Object value) {
        if (!super.containsKey(key)) {
            this._keySequence.add(key);
        }
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        Object oldValue = super.remove(key);
        if (oldValue != null) {
            this._keySequence.remove(key);
        }
        return oldValue;
    }

    public void retain(int count) {
        int size = this._keySequence.size();
        if (size > count) {
            ListIterator<Object> iterator = this._keySequence.listIterator(size);
            while (size > count) {
                Object key = iterator.previous();
                iterator.remove();
                super.remove(key);
                --size;
            }
        }
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean allMatches) {
        Comparator<Object> keyComparator = new Comparator<Object>(){

            @Override
            public int compare(Object key1, Object key2) {
                return key1.toString().compareTo(key2.toString());
            }
        };
        StringBuffer buffer = new StringBuffer("{");
        LinkedList keys = new LinkedList(this.keySet());
        Collections.sort(keys, keyComparator);
        int i = 0;
        for (Object key : keys) {
            if (!allMatches && !(key instanceof NamedObj)) continue;
            if (i++ != 0) {
                buffer.append(", ");
            }
            buffer.append(key);
            buffer.append(" = ");
            buffer.append(this.get(key));
        }
        buffer.append("}");
        return buffer.toString();
    }
}

