/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.List;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLParser;

public class Effigy
extends CompositeEntity {
    public StringAttribute identifier;
    public URIAttribute uri;
    private TableauFactory _factory = null;
    private boolean _isSystemEffigy = false;
    private boolean _modified = false;
    private boolean _modifiable = true;
    private boolean _modifiableURI = true;

    public Effigy(Workspace workspace) {
        super(workspace);
        try {
            this.identifier = new StringAttribute(this, "identifier");
            this.identifier.setExpression("Unnamed");
            this.uri = new URIAttribute(this, "uri");
        }
        catch (Throwable throwable) {
            throw new InternalErrorException(this, throwable, "Can't create identifier!");
        }
    }

    public Effigy(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.identifier = new StringAttribute(this, "identifier");
        this.identifier.setExpression("Unnamed");
        this.uri = new URIAttribute(this, "uri");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.identifier) {
            for (Tableau tableau : this.entityList(Tableau.class)) {
                tableau.setTitle(this.identifier.getExpression());
            }
        } else if (attribute == this.uri) {
            URI uriValue = this.uri.getURI();
            if (uriValue == null) {
                this._modifiableURI = true;
            } else {
                String protocol = uriValue.getScheme();
                if (!protocol.equals("file")) {
                    this._modifiableURI = false;
                } else {
                    String path = uriValue.getPath();
                    if (path != null) {
                        File file = new File(path);
                        try {
                            this._modifiableURI = file.canWrite();
                        }
                        catch (AccessControlException accessControl) {
                            this._modifiableURI = false;
                        }
                    }
                }
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public boolean closeTableaux() {
        for (Effigy effigy : this.entityList(Effigy.class)) {
            if (effigy.closeTableaux()) continue;
            return false;
        }
        for (Tableau tableau : this.entityList(Tableau.class)) {
            if (tableau.close()) continue;
            return false;
        }
        return true;
    }

    public TableauFactory getTableauFactory() {
        return this._factory;
    }

    public File getWritableFile() {
        File tentativeResult;
        String protocol;
        File result = null;
        URI fileURI = this.uri.getURI();
        if (fileURI != null && (protocol = fileURI.getScheme()).equals("file") && (tentativeResult = new File(fileURI)).canWrite()) {
            result = tentativeResult;
        }
        return result;
    }

    public boolean isModifiable() {
        Effigy master = this.masterEffigy();
        if (!master._modifiable) {
            return false;
        }
        return master._modifiableURI;
    }

    public boolean isModified() {
        return this.masterEffigy()._modified;
    }

    public boolean isSystemEffigy() {
        return this._isSystemEffigy;
    }

    public Effigy masterEffigy() {
        return this.topEffigy();
    }

    public int numberOfOpenTableaux() {
        int result = 0;
        List tableaux = this.entityList(Tableau.class);
        result += tableaux.size();
        List containedEffigies = this.entityList(Effigy.class);
        Iterator effigies = containedEffigies.iterator();
        while (effigies.hasNext()) {
            result += ((Effigy)effigies.next()).numberOfOpenTableaux();
        }
        return result;
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        if (container == null) {
            for (ComponentEntity tableau : this.entityList(Tableau.class)) {
                tableau.setContainer(null);
            }
            for (ComponentEntity effigy : this.entityList(Effigy.class)) {
                effigy.setContainer(null);
            }
            if (this.uri != null) {
                try {
                    URL url = this.uri.getURL();
                    MoMLParser.purgeModelRecord(url);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        super.setContainer(container);
    }

    public void setModifiable(boolean flag) {
        this.masterEffigy()._modifiable = flag;
    }

    public void setModified(boolean modified) {
        this.masterEffigy()._modified = modified;
    }

    public void setSystemEffigy(boolean isSystemEffigy) {
        this._isSystemEffigy = isSystemEffigy;
    }

    public void setTableauFactory(TableauFactory factory) {
        this._factory = factory;
    }

    public Tableau showTableaux() {
        for (Effigy effigy : this.entityList(Effigy.class)) {
            effigy.showTableaux();
        }
        Iterator tableaux = this.entityList(Tableau.class).iterator();
        Tableau result = null;
        while (tableaux.hasNext()) {
            Tableau tableau = (Tableau)tableaux.next();
            tableau.show();
            if (result != null) continue;
            result = tableau;
        }
        if (result == null) {
            Configuration configuration = (Configuration)this.toplevel();
            result = configuration.createPrimaryTableau(this);
        }
        return result;
    }

    public Effigy topEffigy() {
        NamedObj container = this.getContainer();
        if (container instanceof Effigy) {
            return ((Effigy)container).topEffigy();
        }
        return this;
    }

    public void writeFile(File file) throws IOException {
        throw new IOException("I do not know how to write this model data.");
    }

    protected void _checkContainer(CompositeEntity container) throws IllegalActionException {
        if (container != null && !(container instanceof ModelDirectory) && !(container instanceof Effigy)) {
            throw new IllegalActionException((Nameable)this, container, "The container can only be set to an instance of ModelDirectory or Effigy.");
        }
    }

    @Override
    protected void _removeEntity(ComponentEntity entity) {
        super._removeEntity(entity);
        if (this.numberOfOpenTableaux() == 0 && !this.isSystemEffigy()) {
            try {
                this.setContainer(null);
            }
            catch (Exception ex) {
                throw new InternalErrorException(this, (Throwable)ex, "Cannot remove effigy!");
            }
        }
    }
}

