/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.io.FileWriter;
import java.net.MalformedURLException;
import java.net.URL;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.TextEffigy;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class ExternalTextEffigy
extends TextEffigy {
    private String _pathName;
    private boolean _useContainerMoML;

    public ExternalTextEffigy(Workspace workspace) {
        super(workspace);
    }

    public ExternalTextEffigy(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        super.attributeChanged(attribute);
        if (attribute == this.identifier) {
            try {
                URL url = new URL(this.identifier.getExpression());
                File file = new File(url.getFile());
                String path = file.getAbsolutePath().replace('\\', '/');
                this.showContent(path);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public static TextEffigy newTextEffigy(CompositeEntity container, String text) throws Exception {
        ExternalTextEffigy effigy = new ExternalTextEffigy(container, container.uniqueName("effigy"));
        effigy.setUseContainerMoML(true);
        return effigy;
    }

    public static TextEffigy newTextEffigy(CompositeEntity container, URL base, URL in) throws Exception {
        ExternalTextEffigy effigy = new ExternalTextEffigy(container, container.uniqueName("effigy"));
        return effigy;
    }

    @Override
    public void setModifiable(boolean flag) {
        super.setModifiable(flag);
    }

    public void show() {
        this.showContent(this._pathName);
    }

    private void setUseContainerMoML(boolean useContainerMoML) {
        this._useContainerMoML = useContainerMoML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showContent(String path) {
        try {
            String todo;
            File tmpFile = null;
            if (this._useContainerMoML) {
                String text = ((PtolemyEffigy)this.getContainer()).getModel().exportMoML();
                tmpFile = File.createTempFile("effigy", "");
                String tmpFilePathName = tmpFile.getAbsolutePath().replace('\\', '/');
                FileWriter writer = null;
                try {
                    writer = new FileWriter(tmpFile);
                    writer.write(text);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
                todo = "gnudoit (find-file (symbol-name '" + path + "))" + "(setq buffer-read-only nil)" + "(erase-buffer)" + "(insert-file-contents " + "    (symbol-name '" + tmpFilePathName + "))" + "(set-buffer-modified-p nil)" + "(setq buffer-read-only t)" + "(buffer-name)";
            } else {
                todo = "gnudoit (find-file (symbol-name '" + path + "))" + "(buffer-name)";
            }
            Process process = Runtime.getRuntime().exec(todo);
            process.waitFor();
            this._pathName = path;
            if (tmpFile != null && !tmpFile.delete()) {
                throw new InternalErrorException("Failed to delete \"" + tmpFile + "\"?");
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(this.getFullName(), throwable);
        }
    }
}

