/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.net.URL;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.PtolemyApplet;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.attributes.VersionAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.Documentation;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.filter.BackwardCompatibility;
import ptolemy.moml.filter.RemoveGraphicalClasses;

public class MoMLApplet
extends PtolemyApplet {
    protected String _fragment = "";
    protected String _modelURL = "";

    @Override
    public String getAppletInfo() {
        String version = "Ptolemy II " + VersionAttribute.CURRENT_VERSION;
        String build = "\n(Build: $Id: MoMLApplet.java,v 1.64 2007/12/07 06:25:03 cxh Exp $)";
        if (this._toplevel != null) {
            String tip = Documentation.consolidate(this._toplevel);
            if (tip != null) {
                return version + " model given in MoML:\n" + tip + build;
            }
            return version + " model given in MoML." + build;
        }
        return "MoML applet for " + version + "\nPtolemy II comes from UC Berkeley, Department of EECS.\n" + "See http://ptolemy.eecs.berkeley.edu/ptolemyII" + build;
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] newInfo = new String[][]{{"modelURL", "", "URL for the MoML file"}};
        return this._concatStringArrays(super.getParameterInfo(), newInfo);
    }

    @Override
    protected NamedObj _createModel(Workspace workspace) throws Exception {
        return this._createModel(workspace, true);
    }

    protected NamedObj _createModel(Workspace workspace, boolean filterGraphicalClasses) throws Exception {
        this._modelURL = this._readModelURLParameter();
        MoMLParser parser = new MoMLParser();
        MoMLParser.setMoMLFilters(null);
        MoMLParser.setMoMLFilters(BackwardCompatibility.allFilters());
        RemoveGraphicalClasses removeNonAppletClasses = new RemoveGraphicalClasses();
        if (!filterGraphicalClasses) {
            RemoveGraphicalClasses.clear();
        }
        removeNonAppletClasses.put("ptolemy.codegen.kernel.StaticSchedulingCodeGenerator", null);
        removeNonAppletClasses.put("ptolemy.vergil.kernel.attributes.DocumentationAttribute", null);
        MoMLParser.addMoMLFilter(removeNonAppletClasses);
        URL docBase = this.getDocumentBase();
        URL xmlFile = new URL(docBase, this._modelURL);
        this._manager = null;
        NamedObj toplevel = parser.parse(docBase, xmlFile);
        this._workspace = toplevel.workspace();
        if (this._fragment != null && !this._fragment.trim().equals("")) {
            ComponentEntity inside = null;
            if (toplevel instanceof CompositeEntity) {
                inside = ((CompositeEntity)toplevel).getEntity(this._fragment);
            }
            if (inside == null) {
                throw new IllegalActionException((Nameable)toplevel, "No such contained entity: " + this._fragment);
            }
            toplevel = inside;
        } else if (toplevel instanceof CompositeActor) {
            CompositeActor result = (CompositeActor)toplevel;
            this._manager = result.getManager();
            if (this._manager == null) {
                this._manager = new Manager(this._workspace, "manager");
                result.setManager(this._manager);
            }
            this._manager.addExecutionListener(this);
        }
        return toplevel;
    }

    protected String _readModelURLParameter() throws Exception {
        int sharp;
        this._modelURL = this.getParameter("modelURL");
        if (this._modelURL == null) {
            this._modelURL = this.getParameter("model");
            if (this._modelURL == null) {
                throw new Exception("Applet does not not specify a modelURL.");
            }
        }
        if ((sharp = this._modelURL.indexOf("#")) > 0) {
            this._fragment = this._modelURL.substring(sharp + 1);
            this._modelURL = this._modelURL.substring(0, sharp);
        }
        return this._modelURL;
    }
}

