/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import ptolemy.actor.TypedIOPort;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.StringUtilities;

public class PortConfigurer
extends Query
implements QueryListener {
    private String[] _cardinals = new String[]{"NORTH", "SOUTH", "EAST", "WEST"};
    private Set _changed = new HashSet();
    private Entity _object;
    private String[] _optionsArray = new String[]{"input", "output", "multiport"};

    public PortConfigurer(Entity object) {
        this.addQueryListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.setTextWidth(15);
        this.setColumns(3);
        this._object = object;
        for (Object candidate : this._object.portList()) {
            if (!(candidate instanceof TypedIOPort)) continue;
            TypedIOPort port = (TypedIOPort)candidate;
            HashSet<String> optionsDefault = new HashSet<String>();
            if (port.isInput()) {
                optionsDefault.add("input");
            }
            if (port.isOutput()) {
                optionsDefault.add("output");
            }
            if (port.isMultiport()) {
                optionsDefault.add("multiport");
            }
            this.addSelectButtons(port.getName(), port.getName(), this._optionsArray, optionsDefault);
            String typeEntryName = port.getName() + " type";
            this.addLine(typeEntryName, typeEntryName, ((Object)port.getType()).toString());
            StringAttribute cardinal = (StringAttribute)port.getAttribute("_cardinal");
            String cardinalValue = "SOUTH";
            if (cardinal != null) {
                cardinalValue = cardinal.getExpression().toUpperCase();
            } else if (port.isInput() && !port.isOutput()) {
                cardinalValue = "WEST";
            } else if (port.isOutput() && !port.isInput()) {
                cardinalValue = "EAST";
            }
            this.addChoice(port.getName() + " cardinal", port.getName() + ": cardinal direction", this._cardinals, cardinalValue);
        }
    }

    public void apply() {
        StringBuffer moml = new StringBuffer("<group>");
        boolean foundOne = false;
        Iterator ports = this._object.portList().iterator();
        NamedObj parent = null;
        while (ports.hasNext()) {
            Object candidate = ports.next();
            if (!(candidate instanceof TypedIOPort)) continue;
            TypedIOPort port = (TypedIOPort)candidate;
            String name = port.getName();
            String nameCardinal = name + " cardinal";
            if (this._changed.contains(nameCardinal)) {
                parent = port.getContainer();
                foundOne = true;
                moml.append("<port name=\"");
                moml.append(port.getName());
                moml.append("\">");
                String cardinalVal = this.getStringValue(nameCardinal);
                moml.append("<property name=\"_cardinal\" class = \"ptolemy.kernel.util.StringAttribute\" value = \"" + cardinalVal + "\"/>");
                moml.append("</port>");
            }
            String typeEntryName = name + " type";
            if (!this._changed.contains(name) && !this._changed.contains(typeEntryName)) continue;
            String value = this.getStringValue(name);
            HashSet<String> selectedValues = new HashSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                selectedValues.add(tokenizer.nextToken().trim());
            }
            parent = port.getContainer();
            foundOne = true;
            moml.append("<port name=\"");
            moml.append(port.getName());
            moml.append("\">");
            if (selectedValues.contains("input")) {
                moml.append("<property name=\"input\"/>");
            } else {
                moml.append("<property name=\"input\" value=\"false\"/>");
            }
            if (selectedValues.contains("output")) {
                moml.append("<property name=\"output\"/>");
            } else {
                moml.append("<property name=\"output\" value=\"false\"/>");
            }
            if (selectedValues.contains("multiport")) {
                moml.append("<property name=\"multiport\"/>");
            } else {
                moml.append("<property name=\"multiport\" value=\"false\"/>");
            }
            if (this._changed.contains(typeEntryName)) {
                String type = this.getStringValue(typeEntryName);
                moml.append("<property name=\"_type\" class = \"ptolemy.actor.TypeAttribute\" value = \"" + StringUtilities.escapeForXML(type) + "\"/>");
            }
            moml.append("</port>");
        }
        if (foundOne) {
            moml.append("</group>");
            MoMLChangeRequest request = new MoMLChangeRequest(this, parent, moml.toString(), null);
            request.setUndoable(true);
            parent.requestChange(request);
        }
    }

    @Override
    public void changed(String name) {
        this._changed.add(name);
    }
}

