/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import ptolemy.actor.Actor;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypeAttribute;
import ptolemy.actor.TypedActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.actor.gui.PtolemyDialog;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.Constants;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.unit.ParseException;
import ptolemy.data.unit.UnitAttribute;
import ptolemy.data.unit.UnitLibrary;
import ptolemy.data.unit.UnitUtilities;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.undo.UndoChangeRequest;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.basic.LocatableNodeController;
import ptolemy.vergil.kernel.VergilUtilities;

public class PortConfigurerDialog
extends PtolemyDialog
implements ChangeListener {
    private ArrayList _columnNames;
    private boolean _hideAllPorts = false;
    private JComboBox _portLocationComboBox;
    JTable _portTable;
    PortTableModel _portTableModel = null;
    JTableHeader _jth;
    static ParseTreeEvaluator _parseTreeEvaluator = new ParseTreeEvaluator();
    Vector _ports = null;
    private int _selectedRow = -1;
    private static String _SINGLETON_PARAMETER = "ptolemy.data.expr.SingletonParameter";
    private boolean _showAllNames = false;
    private static String _STRING_ATTRIBUTE = "ptolemy.kernel.util.StringAttribute";
    static PtParser _typeParser = new PtParser();
    private static String _UNIT_ATTRIBUTE = "ptolemy.data.unit.UnitAttribute";
    private JButton _applyButton;
    private JButton Button;
    private JButton _addButton;
    private JButton _removeButton;

    public PortConfigurerDialog(DialogTableau tableau, Frame owner, Entity target, Configuration configuration) {
        super("Configure ports for " + target.getName(), tableau, owner, target, configuration);
        this.getTarget().addChangeListener(this);
        this._portLocationComboBox = new JComboBox();
        this._portLocationComboBox.addItem("DEFAULT");
        this._portLocationComboBox.addItem("NORTH");
        this._portLocationComboBox.addItem("EAST");
        this._portLocationComboBox.addItem("SOUTH");
        this._portLocationComboBox.addItem("WEST");
        this._portTable = new JTable();
        this._portTable.setPreferredScrollableViewportSize(new Dimension(600, 70));
        this._portTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (VergilUtilities.macOSLookAndFeel() && (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 1 && (mouseEvent.getModifiersEx() | 2) == 2) || !VergilUtilities.macOSLookAndFeel() && mouseEvent.getButton() == 3) {
                    Point point = mouseEvent.getPoint();
                    int row = PortConfigurerDialog.this._portTable.rowAtPoint(point);
                    PortConfigurerDialog.this._setSelectedRow(row);
                }
            }
        });
        this._portTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent ke) {
                if (ke.getKeyChar() == '\n' && PortConfigurerDialog.this._apply()) {
                    PortConfigurerDialog.this._cancel();
                }
            }
        });
        this._portTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
                PortConfigurerDialog.this._setSelectedRow(PortConfigurerDialog.this._portTable.getSelectionModel().getAnchorSelectionIndex());
            }

            @Override
            public void focusLost(FocusEvent event) {
            }
        });
        this._initColumnNames();
        this._setupTableModel();
        this._initColumnSizes();
        this.setScrollableContents(this._portTable);
        this._jth = this._portTable.getTableHeader();
        if (this._columnNames.contains("Show Name") || this._columnNames.contains("Hide")) {
            this._jth.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    Rectangle headerHidePortRect;
                    int hide;
                    Rectangle headerShowNameRect;
                    int showName = PortConfigurerDialog.this._columnNames.indexOf("Show Name");
                    if (showName != -1 && (headerShowNameRect = PortConfigurerDialog.this._jth.getHeaderRect(showName)).contains(me.getPoint())) {
                        PortConfigurerDialog.this._portTableModel.toggleShowAllNames();
                    }
                    if ((hide = PortConfigurerDialog.this._columnNames.indexOf("Hide")) != 1 && (headerHidePortRect = PortConfigurerDialog.this._jth.getHeaderRect(hide)).contains(me.getPoint())) {
                        PortConfigurerDialog.this._portTableModel.toggleHidePorts();
                    }
                }
            });
        }
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void changeExecuted(ChangeRequest change) {
        if (change == null || change.getSource() == this || !(change instanceof UndoChangeRequest)) {
            return;
        }
        this._setupTableModel();
    }

    @Override
    public void changeFailed(ChangeRequest change, Exception exception) {
        if (change == null) {
            return;
        }
        if (!change.isErrorReported()) {
            MessageHandler.error("Change failed: ", exception);
        }
    }

    public boolean close() {
        if (this._isDirty()) {
            int option = JOptionPane.showConfirmDialog(this.getOwner(), "Save port modifications on " + this.getTarget().getFullName(), "Unsaved Port Modifications", 1);
            switch (option) {
                case 0: {
                    this._apply();
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void saveIfRequired() {
        if (this._isDirty()) {
            int option = JOptionPane.showConfirmDialog(this.getOwner(), "Save port modifications on " + this.getTarget().getFullName() + "?", "Unsaved Port Modifications", 0);
            switch (option) {
                case 0: {
                    this._apply();
                }
            }
        }
    }

    protected boolean _apply() {
        int i;
        String[] portNameInTable = new String[this._portTableModel.getRowCount()];
        for (i = 0; i < this._portTableModel.getRowCount(); ++i) {
            portNameInTable[i] = (String)this._portTableModel.getValueAt(i, this._columnNames.indexOf("Name"));
        }
        for (i = 0; i < this._portTableModel.getRowCount(); ++i) {
            if (!portNameInTable[i].equals("")) continue;
            JOptionPane.showMessageDialog(this, "All Ports need to have a name.");
            return false;
        }
        for (i = 0; i < this._portTableModel.getRowCount(); ++i) {
            for (int j = i + 1; j < this._portTableModel.getRowCount(); ++j) {
                if (!portNameInTable[i].equals(portNameInTable[j])) continue;
                JOptionPane.showMessageDialog(this, portNameInTable[i] + " is a duplicate port name.\n" + "Please remove all but one");
                return false;
            }
        }
        Vector<Port> portsToBeRemoved = new Vector<Port>();
        Iterator portIterator = this.getTarget().portList().iterator();
        Port actualPort = null;
        while (portIterator.hasNext()) {
            Object candidate = portIterator.next();
            if (candidate instanceof Port) {
                boolean foundPort = false;
                actualPort = (Port)candidate;
                if (actualPort == null) {
                    throw new InternalErrorException("The target contains a null Port.");
                }
                for (int i2 = 0; i2 < this._ports.size(); ++i2) {
                    Hashtable portInfo = (Hashtable)this._ports.elementAt(i2);
                    if (actualPort != (Port)portInfo.get("9")) continue;
                    foundPort = true;
                    break;
                }
                if (foundPort) continue;
                portsToBeRemoved.add(actualPort);
                continue;
            }
            throw new InternalErrorException("The target portList contains an object that is not of type Port.");
        }
        Iterator actualPorts = portsToBeRemoved.iterator();
        while (actualPorts.hasNext()) {
            StringBuffer moml = new StringBuffer();
            actualPort = (Port)actualPorts.next();
            NamedObj container = actualPort.getContainer();
            NamedObj composite = container.getContainer();
            if (composite != null) {
                moml.append("<deletePort name=\"" + actualPort.getName() + "\" entity=\"" + container.getName() + "\" />");
            } else {
                moml.append("<deletePort name=\"" + actualPort.getName(container) + "\" />");
            }
            MoMLChangeRequest request = null;
            request = composite != null ? new MoMLChangeRequest(this, composite, moml.toString()) : new MoMLChangeRequest(this, container, moml.toString());
            request.setUndoable(true);
            container.addChangeListener(this);
            container.requestChange(request);
        }
        StringBuffer moml = new StringBuffer("<group>");
        boolean haveSomeUpdate = false;
        for (int i3 = 0; i3 < this._ports.size(); ++i3) {
            Hashtable portInfo = (Hashtable)this._ports.elementAt(i3);
            portIterator = this.getTarget().portList().iterator();
            actualPort = (Port)portInfo.get("9");
            Hashtable<String, Boolean> updates = new Hashtable<String, Boolean>();
            if (actualPort != null) {
                boolean isHideSet;
                boolean isShowSet;
                Boolean tableValue;
                boolean havePortUpdate = false;
                if (this._columnNames.contains("Name")) {
                    String tableValue2 = (String)portInfo.get("Name");
                    if (!actualPort.getName().equals(tableValue2)) {
                        havePortUpdate = true;
                        updates.put("Name", Boolean.TRUE);
                    }
                }
                if (actualPort instanceof IOPort) {
                    IOPort iop = (IOPort)actualPort;
                    if (this._columnNames.contains("Input")) {
                        tableValue = (Boolean)portInfo.get("Input");
                        if (iop.isInput() != tableValue.booleanValue()) {
                            havePortUpdate = true;
                            updates.put("Input", Boolean.TRUE);
                        }
                    }
                    if (this._columnNames.contains("Output")) {
                        tableValue = (Boolean)portInfo.get("Output");
                        if (iop.isOutput() != tableValue.booleanValue()) {
                            havePortUpdate = true;
                            updates.put("Output", Boolean.TRUE);
                        }
                    }
                    if (this._columnNames.contains("Multiport")) {
                        tableValue = (Boolean)portInfo.get("Multiport");
                        if (iop.isMultiport() != tableValue.booleanValue()) {
                            havePortUpdate = true;
                            updates.put("Multiport", Boolean.TRUE);
                        }
                    }
                }
                if (this._columnNames.contains("Show Name") && (isShowSet = this._isPropertySet(actualPort, "_showName")) != (tableValue = (Boolean)portInfo.get("Show Name"))) {
                    havePortUpdate = true;
                    updates.put("Show Name", Boolean.TRUE);
                }
                if (this._columnNames.contains("Hide") && (isHideSet = this._isPropertySet(actualPort, "_hide")) != (tableValue = (Boolean)portInfo.get("Hide"))) {
                    havePortUpdate = true;
                    updates.put("Hide", Boolean.TRUE);
                }
                if (actualPort instanceof TypedIOPort) {
                    TypedIOPort tiop = (TypedIOPort)actualPort;
                    if (this._columnNames.contains("Type")) {
                        String _type = null;
                        TypeAttribute _typeAttribute = (TypeAttribute)tiop.getAttribute("_type");
                        if (_typeAttribute != null) {
                            _type = _typeAttribute.getExpression();
                        }
                        String tableValue3 = (String)portInfo.get("Type");
                        if (_type == null && !tableValue3.equals("") || _type != null && !tableValue3.equals(_type)) {
                            havePortUpdate = true;
                            updates.put("Type", Boolean.TRUE);
                        }
                    }
                }
                if (this._columnNames.contains("Direction")) {
                    String _direction = null;
                    String direction = (String)portInfo.get("Direction");
                    StringAttribute _cardinal = (StringAttribute)actualPort.getAttribute("_cardinal");
                    if (_cardinal != null) {
                        _direction = _cardinal.getExpression().toUpperCase();
                    }
                    if (_direction == null && !direction.equals("DEFAULT") || _direction != null && !direction.equals(_direction)) {
                        havePortUpdate = true;
                        updates.put("Direction", Boolean.TRUE);
                    }
                }
                if (this._columnNames.contains("Units")) {
                    String units = null;
                    UnitAttribute _unitsAttribute = (UnitAttribute)actualPort.getAttribute("_units");
                    if (_unitsAttribute != null) {
                        units = _unitsAttribute.getExpression();
                    }
                    String tableValue4 = (String)portInfo.get("Units");
                    if (units == null && !tableValue4.equals("") || units != null && !tableValue4.equals(units)) {
                        havePortUpdate = true;
                        updates.put("Units", Boolean.TRUE);
                    }
                }
                if (!havePortUpdate) continue;
                String currentPortName = ((Port)portInfo.get("9")).getName();
                String newPortName = (String)portInfo.get("Name");
                String momlString = this._createMoMLUpdate(updates, portInfo, currentPortName, newPortName);
                moml.append(momlString);
                haveSomeUpdate = true;
                continue;
            }
            for (String element : this._columnNames) {
                updates.put(element, Boolean.TRUE);
            }
            if (this._columnNames.contains("Name")) {
                updates.put("Name", Boolean.FALSE);
            }
            if (this._columnNames.contains("Show Name")) {
                updates.put("Show Name", (Boolean)portInfo.get("Show Name"));
            }
            if (this._columnNames.contains("Hide")) {
                updates.put("Hide", (Boolean)portInfo.get("Hide"));
            }
            if (this._columnNames.contains("Type")) {
                String type = (String)portInfo.get("Type");
                if (!type.equals("")) {
                    updates.put("Type", Boolean.TRUE);
                    this._portTableModel.fireTableDataChanged();
                } else {
                    updates.put("Type", Boolean.FALSE);
                }
            }
            if (this._columnNames.contains("Direction")) {
                String direction = (String)portInfo.get("Direction");
                if (!direction.equals("DEFAULT")) {
                    updates.put("Direction", Boolean.TRUE);
                    this._portTableModel.fireTableDataChanged();
                } else {
                    updates.put("Direction", Boolean.FALSE);
                }
            }
            if (this._columnNames.contains("Units")) {
                String unit = (String)portInfo.get("Units");
                if (!unit.equals("")) {
                    updates.put("Units", Boolean.TRUE);
                    this._portTableModel.fireTableDataChanged();
                } else {
                    updates.put("Units", Boolean.FALSE);
                }
            }
            moml.append(this._createMoMLUpdate(updates, portInfo, (String)portInfo.get("Name"), null));
            haveSomeUpdate = true;
        }
        if (haveSomeUpdate) {
            moml.append("</group>");
            MoMLChangeRequest request = new MoMLChangeRequest(this, this.getTarget(), moml.toString(), null);
            request.setUndoable(true);
            this.getTarget().requestChange(request);
            this._populateActualPorts();
        }
        this._setDirty(false);
        this._enableApplyButton(false);
        this._setSelectedRow(this._portTable.getSelectionModel().getAnchorSelectionIndex());
        return true;
    }

    @Override
    protected void _cancel() {
        this.getTarget().removeChangeListener(this);
        super._cancel();
    }

    @Override
    protected void _createExtendedButtons(JPanel _buttons) {
        this.Button = new JButton("Commit");
        _buttons.add(this.Button);
        this._applyButton = new JButton("Apply");
        _buttons.add(this._applyButton);
        this._addButton = new JButton("Add");
        _buttons.add(this._addButton);
        this._removeButton = new JButton("Remove           ");
        this._removeButton.setEnabled(false);
        _buttons.add(this._removeButton);
    }

    @Override
    protected URL _getHelpURL() {
        URL helpURL = this.getClass().getClassLoader().getResource("ptolemy/actor/gui/doc/portConfigurerDialog.htm");
        return helpURL;
    }

    @Override
    protected void _processButtonPress(String button) {
        if (this._portTable.isEditing()) {
            this._portTable.editingStopped(new ChangeEvent(button));
        }
        this._portTableModel.fireTableDataChanged();
        if (button.equals("Apply")) {
            this._apply();
        } else if (button.equals("Commit")) {
            if (this._apply()) {
                this._cancel();
            }
        } else if (button.equals("Add")) {
            this._portTableModel.addNewPort();
        } else if (button.length() > 5 && button.substring(0, 6).equals("Remove")) {
            this._portTableModel.removePort();
            this._setSelectedRow(-1);
        } else {
            super._processButtonPress(button);
        }
    }

    private String _createMoMLUpdate(Hashtable updates, Hashtable portInfo, String currentPortName, String newPortName) {
        Attribute attribute;
        Port port;
        Boolean updateValue;
        StringBuffer momlUpdate = new StringBuffer("<port name=\"" + currentPortName + "\">");
        if (updates.containsKey("Name") && (updateValue = (Boolean)updates.get("Name")).booleanValue()) {
            momlUpdate.append("<rename name=\"" + newPortName + "\"/>");
        }
        if (updates.containsKey("Input") && (updateValue = (Boolean)updates.get("Input")).booleanValue()) {
            if (((Boolean)portInfo.get("Input")).booleanValue()) {
                momlUpdate.append(this._momlProperty("input"));
            } else {
                momlUpdate.append(this._momlProperty("input", null, "false"));
            }
        }
        if (updates.containsKey("Output") && (updateValue = (Boolean)updates.get("Output")).booleanValue()) {
            if (((Boolean)portInfo.get("Output")).booleanValue()) {
                momlUpdate.append(this._momlProperty("output"));
            } else {
                momlUpdate.append(this._momlProperty("output", null, "false"));
            }
        }
        if (updates.containsKey("Multiport") && (updateValue = (Boolean)updates.get("Multiport")).booleanValue()) {
            if (((Boolean)portInfo.get("Multiport")).booleanValue()) {
                momlUpdate.append(this._momlProperty("multiport"));
            } else {
                momlUpdate.append(this._momlProperty("multiport", null, "false"));
            }
        }
        if (updates.containsKey("Type") && (updateValue = (Boolean)updates.get("Type")).booleanValue()) {
            String type = (String)portInfo.get("Type");
            if (type.equals("")) {
                momlUpdate.append(this._momlDeleteProperty("_type"));
            } else {
                momlUpdate.append(this._momlProperty("_type", "ptolemy.actor.TypeAttribute", StringUtilities.escapeForXML(type)));
            }
        }
        if (updates.containsKey("Direction") && (updateValue = (Boolean)updates.get("Direction")).booleanValue()) {
            String direction = (String)portInfo.get("Direction");
            if (direction.equals("DEFAULT")) {
                momlUpdate.append(this._momlDeleteProperty("_cardinal"));
            } else {
                momlUpdate.append(this._momlProperty("_cardinal", _STRING_ATTRIBUTE, direction));
            }
        }
        if (updates.containsKey("Show Name") && (updateValue = (Boolean)updates.get("Show Name")).booleanValue()) {
            if (((Boolean)portInfo.get("Show Name")).booleanValue()) {
                momlUpdate.append(this._momlProperty("_showName", _SINGLETON_PARAMETER, "true"));
            } else {
                boolean removed = false;
                port = (Port)portInfo.get("9");
                if (port != null && !((attribute = port.getAttribute("_showName")) instanceof Parameter)) {
                    momlUpdate.append(this._momlDeleteProperty("_showName"));
                    removed = true;
                }
                if (!removed) {
                    momlUpdate.append(this._momlProperty("_showName", _SINGLETON_PARAMETER, "false"));
                }
            }
        }
        if (updates.containsKey("Hide") && (updateValue = (Boolean)updates.get("Hide")).booleanValue()) {
            if (((Boolean)portInfo.get("Hide")).booleanValue()) {
                momlUpdate.append(this._momlProperty("_hide", _SINGLETON_PARAMETER, "true"));
            } else {
                boolean removed = false;
                port = (Port)portInfo.get("9");
                if (port != null && !((attribute = port.getAttribute("_hide")) instanceof Parameter)) {
                    momlUpdate.append(this._momlDeleteProperty("_hide"));
                    removed = true;
                }
                if (!removed) {
                    momlUpdate.append(this._momlProperty("_hide", _SINGLETON_PARAMETER, "false"));
                }
            }
        }
        if (updates.containsKey("Units") && (updateValue = (Boolean)updates.get("Units")).booleanValue()) {
            momlUpdate.append(this._momlProperty("_units", _UNIT_ATTRIBUTE, (String)portInfo.get("Units")));
        }
        momlUpdate.append("</port>");
        return momlUpdate.toString();
    }

    private JComboBox _createComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent ke) {
                PortConfigurerDialog.this._setDirty(true);
                PortConfigurerDialog.this._enableApplyButton(true);
            }
        });
        jComboBox.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
                PortConfigurerDialog.this._setSelectedRow(PortConfigurerDialog.this._portTable.getSelectionModel().getAnchorSelectionIndex());
            }

            @Override
            public void focusLost(FocusEvent event) {
            }
        });
        jComboBox.setEditable(true);
        jComboBox.addItem("");
        return jComboBox;
    }

    private JComboBox _createPortTypeComboBox() {
        JComboBox jComboBox = this._createComboBox();
        TreeMap typeMap = Constants.types();
        for (String type : typeMap.keySet()) {
            jComboBox.addItem(type);
        }
        jComboBox.addItem("arrayType(int)");
        jComboBox.addItem("arrayType(int,5)");
        jComboBox.addItem("[double]");
        jComboBox.addItem("{x=double, y=double}");
        return jComboBox;
    }

    private JComboBox _createPortUnitComboBox() {
        JComboBox jComboBox = this._createComboBox();
        ArrayList unitsArrayList = UnitUtilities.categoryList();
        Collections.sort(unitsArrayList);
        for (String unit : unitsArrayList) {
            jComboBox.addItem(unit);
        }
        jComboBox.addItem("meter second ^-1");
        return jComboBox;
    }

    private void _enableApplyButton(boolean e) {
        this._applyButton.setEnabled(e);
    }

    private void _initColumnNames() {
        String[] temp;
        Entity target = this.getTarget();
        String[] tempColumnNames = null;
        tempColumnNames = target instanceof TypedActor ? (temp = new String[]{"Name", "Input", "Output", "Multiport", "Type", "Direction", "Show Name", "Hide", "Units"}) : (target instanceof Actor ? (temp = new String[]{"Name", "Input", "Output", "Multiport", "Direction", "Show Name", "Hide"}) : (temp = new String[]{"Name", "Direction", "Show Name", "Hide"}));
        List<String> columnList = Arrays.asList(tempColumnNames);
        this._columnNames = new ArrayList<String>(columnList);
    }

    private void _initColumnSizes() {
        int index;
        TableColumn column = null;
        if (this._columnNames.contains("Input")) {
            index = this._columnNames.indexOf("Input");
            column = this._portTable.getColumnModel().getColumn(index);
            column.setPreferredWidth(30);
        }
        if (this._columnNames.contains("Output")) {
            index = this._columnNames.indexOf("Output");
            column = this._portTable.getColumnModel().getColumn(index);
            column.setPreferredWidth(30);
        }
        if (this._columnNames.contains("Multiport")) {
            index = this._columnNames.indexOf("Multiport");
            column = this._portTable.getColumnModel().getColumn(index);
            column.setPreferredWidth(40);
        }
        if (this._columnNames.contains("Type")) {
            index = this._columnNames.indexOf("Type");
            column = this._portTable.getColumnModel().getColumn(index);
            column.setPreferredWidth(70);
        }
        if (this._columnNames.contains("Direction")) {
            index = this._columnNames.indexOf("Direction");
            column = this._portTable.getColumnModel().getColumn(index);
            column.setPreferredWidth(50);
        }
        if (this._columnNames.contains("Show Name")) {
            index = this._columnNames.indexOf("Show Name");
            column = this._portTable.getColumnModel().getColumn(index);
            column.setPreferredWidth(70);
        }
        if (this._columnNames.contains("Hide")) {
            index = this._columnNames.indexOf("Hide");
            column = this._portTable.getColumnModel().getColumn(index);
            column.setPreferredWidth(30);
        }
    }

    private boolean _isPropertySet(NamedObj object, String name) {
        Attribute attribute = object.getAttribute(name);
        if (attribute == null) {
            return false;
        }
        if (attribute instanceof Parameter) {
            try {
                Token token = ((Parameter)attribute).getToken();
                if (token instanceof BooleanToken && !((BooleanToken)token).booleanValue()) {
                    return false;
                }
            }
            catch (IllegalActionException e) {
                // empty catch block
            }
        }
        return true;
    }

    private String _momlDeleteProperty(String name) {
        return "<deleteProperty name=\"" + name + "\"/>";
    }

    private String _momlProperty(String name) {
        return "<property name=\"" + name + "\"/>";
    }

    private String _momlProperty(String name, String clz, String value) {
        if (clz != null) {
            return "<property name=\"" + name + "\" " + "class = \"" + clz + "\" " + "value = \"" + value + "\"/>";
        }
        return "<property name=\"" + name + "\" " + "value = \"" + value + "\"/>";
    }

    private void _populateActualPorts() {
        for (int i = 0; i < this._ports.size(); ++i) {
            Hashtable portInfo = (Hashtable)this._ports.elementAt(i);
            String portName = (String)portInfo.get("Name");
            Iterator portIterator = this.getTarget().portList().iterator();
            boolean foundActualPort = false;
            while (portIterator.hasNext()) {
                Port actualPort;
                Object candidate = portIterator.next();
                if (!(candidate instanceof Port) || !(actualPort = (Port)candidate).getName().equals(portName)) continue;
                portInfo.put("9", actualPort);
                foundActualPort = true;
                break;
            }
            if (foundActualPort) continue;
            throw new InternalErrorException("Port stored in _ports not found in actual target.");
        }
    }

    private void _setSelectedRow(int row) {
        this._selectedRow = row;
        if (row < 0) {
            this._removeButton.setText("Remove");
            this._removeButton.setEnabled(false);
        } else {
            Hashtable portInfo = (Hashtable)this._ports.elementAt(row);
            String portName = (String)portInfo.get("Name");
            if (portName.length() == 0) {
                portName = "#" + (row + 1);
            }
            if (portName.length() < 10) {
                portName = portName + "          ";
                portName = portName.substring(0, 9);
            } else if (portName.length() > 10) {
                portName = portName.substring(0, 7) + "...";
            }
            this._removeButton.setText("Remove " + portName);
            this._removeButton.setEnabled(this._portTable.isCellEditable(row, 0));
        }
    }

    private void _setupTableModel() {
        int col;
        this._portTableModel = new PortTableModel(this.getTarget().portList());
        this._portTable.setModel(this._portTableModel);
        this._portTable.setDefaultRenderer(Boolean.class, new PortBooleanCellRenderer());
        this._portTable.setDefaultRenderer(String.class, new StringCellRenderer());
        this._portTable.setDefaultEditor(String.class, new ValidatingJTextFieldCellEditor());
        this._enableApplyButton(false);
        if (this._columnNames.contains("Name")) {
            col = this._columnNames.indexOf("Name");
            TableColumn _portNameColumn = this._portTable.getColumnModel().getColumn(col);
            ValidatingJTextFieldCellEditor portNameEditor = new ValidatingJTextFieldCellEditor(new JFormattedTextField());
            _portNameColumn.setCellEditor(portNameEditor);
            portNameEditor.setValidator(new CellValidator(){

                @Override
                public boolean isValid(String cellValue) {
                    int index = cellValue.indexOf(".");
                    if (index >= 0) {
                        this.setMessage(cellValue + " contains a period in col " + (index + 1));
                        return false;
                    }
                    if (cellValue.equals("")) {
                        this.setMessage("Ports cannot have the empty string as a name.");
                        return false;
                    }
                    return true;
                }
            });
        }
        if (this._columnNames.contains("Direction")) {
            col = this._columnNames.indexOf("Direction");
            TableColumn _portLocationColumn = this._portTable.getColumnModel().getColumn(col);
            _portLocationColumn.setCellEditor(new DefaultCellEditor(this._portLocationComboBox));
        }
        if (this._columnNames.contains("Type")) {
            col = this._columnNames.indexOf("Type");
            TableColumn _portTypeColumn = this._portTable.getColumnModel().getColumn(col);
            ValidatingComboBoxCellEditor portTypeEditor = new ValidatingComboBoxCellEditor(this._createPortTypeComboBox());
            _portTypeColumn.setCellEditor(portTypeEditor);
            portTypeEditor.setValidator(new CellValidator(){

                @Override
                public boolean isValid(String cellValue) {
                    try {
                        if (cellValue.equals("")) {
                            return true;
                        }
                        if (cellValue.equals("pointer")) {
                            return true;
                        }
                        ASTPtRootNode tree = _typeParser.generateParseTree(cellValue);
                        _parseTreeEvaluator.evaluateParseTree(tree, null);
                    }
                    catch (IllegalActionException e) {
                        this.setMessage(e.getMessage());
                        return false;
                    }
                    return true;
                }
            });
        }
        if (this._columnNames.contains("Units")) {
            col = this._columnNames.indexOf("Units");
            TableColumn _portUnitColumn = this._portTable.getColumnModel().getColumn(col);
            ValidatingComboBoxCellEditor portUnitEditor = new ValidatingComboBoxCellEditor(this._createPortUnitComboBox());
            _portUnitColumn.setCellEditor(portUnitEditor);
            portUnitEditor.setValidator(new CellValidator(){

                @Override
                public boolean isValid(String cellValue) {
                    try {
                        UnitLibrary.getParser().parseUnitExpr(cellValue);
                    }
                    catch (ParseException e) {
                        this.setMessage(e.getMessage());
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    private static class ColumnNames {
        public static final String COL_NAME = "Name";
        public static final String COL_INPUT = "Input";
        public static final String COL_OUTPUT = "Output";
        public static final String COL_MULTIPORT = "Multiport";
        public static final String COL_TYPE = "Type";
        public static final String COL_DIRECTION = "Direction";
        public static final String COL_SHOW_NAME = "Show Name";
        public static final String COL_HIDE = "Hide";
        public static final String COL_UNITS = "Units";
        public static final String COL_ACTUAL_PORT = "9";

        private ColumnNames() {
        }
    }

    public class ValidatingComboBoxCellEditor
    extends DefaultCellEditor {
        private JComboBox _comboBox;
        private Object _oldValue;
        private boolean _userWantsToEdit;
        private CellValidator _validator;

        public ValidatingComboBoxCellEditor(final JComboBox comboBox) {
            super(comboBox);
            this._comboBox = (JComboBox)this.getComponent();
            comboBox.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
            comboBox.getActionMap().put("check", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean valid = true;
                    if (ValidatingComboBoxCellEditor.this._validator != null) {
                        valid = ValidatingComboBoxCellEditor.this._validator.isValid((String)comboBox.getSelectedItem());
                    }
                    if (!valid) {
                        ValidatingComboBoxCellEditor.this.userSaysRevert((String)comboBox.getSelectedItem());
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox comboBox = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this._oldValue = comboBox.getSelectedItem();
            comboBox.setSelectedItem(value);
            return comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            JComboBox comboBox = (JComboBox)this.getComponent();
            Object o = comboBox.getSelectedItem();
            return o.toString();
        }

        public void setValidator(CellValidator validator) {
            this._validator = validator;
        }

        @Override
        public boolean stopCellEditing() {
            JComboBox comboBox = (JComboBox)this.getComponent();
            if (comboBox.getSelectedItem() == null) {
                comboBox.setSelectedItem("");
            }
            boolean valid = true;
            if (this._validator != null) {
                valid = this._validator.isValid((String)comboBox.getSelectedItem());
            }
            if (!valid) {
                if (this._userWantsToEdit) {
                    this._userWantsToEdit = false;
                    return false;
                }
                if (!this.userSaysRevert((String)comboBox.getSelectedItem())) {
                    this._userWantsToEdit = true;
                    return false;
                }
            }
            return super.stopCellEditing();
        }

        protected boolean userSaysRevert(String selectedItem) {
            Toolkit.getDefaultToolkit().beep();
            Object[] options = new Object[]{"Edit", "Revert"};
            int answer = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this._comboBox), "The value \"" + selectedItem + "\" is not valid:\n" + this._validator.getMessage() + "\nYou can either continue editing " + "or revert to the last valid value \"" + this._oldValue + "\".", "Invalid Text Entered", 0, 0, null, options, options[1]);
            if (answer == 1) {
                this._comboBox.setSelectedItem(this._oldValue);
                return true;
            }
            return false;
        }
    }

    public class ValidatingJTextFieldCellEditor
    extends DefaultCellEditor {
        private JFormattedTextField _jFormattedTextField;
        private Object _oldValue;
        private boolean _userWantsToEdit;
        private CellValidator _validator;

        public ValidatingJTextFieldCellEditor() {
            super(new JFormattedTextField());
        }

        public ValidatingJTextFieldCellEditor(final JFormattedTextField jFormattedTextField) {
            super(jFormattedTextField);
            this._jFormattedTextField = (JFormattedTextField)this.getComponent();
            jFormattedTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
            jFormattedTextField.getActionMap().put("check", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean valid = true;
                    if (ValidatingJTextFieldCellEditor.this._validator != null) {
                        valid = ValidatingJTextFieldCellEditor.this._validator.isValid(jFormattedTextField.getText());
                    }
                    if (!valid) {
                        ValidatingJTextFieldCellEditor.this.userSaysRevert(jFormattedTextField.getText());
                    } else {
                        jFormattedTextField.postActionEvent();
                    }
                }
            });
            this._jFormattedTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent ke) {
                    PortConfigurerDialog.this._setDirty(true);
                    PortConfigurerDialog.this._enableApplyButton(true);
                    if (ke.getKeyChar() == '\n' && PortConfigurerDialog.this._apply()) {
                        PortConfigurerDialog.this._cancel();
                    }
                }
            });
            this._jFormattedTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent event) {
                    PortConfigurerDialog.this._setSelectedRow(PortConfigurerDialog.this._portTable.getSelectionModel().getAnchorSelectionIndex());
                }

                @Override
                public void focusLost(FocusEvent event) {
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField jTextField = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this._oldValue = jTextField.getText();
            jTextField.setText((String)value);
            return jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            JTextField jTextField = (JTextField)this.getComponent();
            String o = jTextField.getText();
            return o.toString();
        }

        public void setValidator(CellValidator validator) {
            this._validator = validator;
        }

        @Override
        public boolean stopCellEditing() {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getComponent();
            if (jFormattedTextField.getText() == null) {
                jFormattedTextField.setText("");
            }
            boolean valid = true;
            if (this._validator != null) {
                valid = this._validator.isValid(jFormattedTextField.getText());
            }
            if (!valid) {
                if (this._userWantsToEdit) {
                    this._userWantsToEdit = false;
                    return false;
                }
                if (!this.userSaysRevert(jFormattedTextField.getText())) {
                    this._userWantsToEdit = true;
                    return false;
                }
            }
            return super.stopCellEditing();
        }

        protected boolean userSaysRevert(String selectedItem) {
            Toolkit.getDefaultToolkit().beep();
            this._jFormattedTextField.selectAll();
            Object[] options = new Object[]{"Edit", "Revert"};
            int answer = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this._jFormattedTextField), "The value \"" + selectedItem + "\" is not valid:\n" + this._validator.getMessage() + "\nYou can either continue editing " + "or revert to the last valid value \"" + this._oldValue + "\".", "Invalid Text Entered", 0, 0, null, options, options[1]);
            if (answer == 1) {
                this._jFormattedTextField.setText((String)this._oldValue);
                return true;
            }
            return false;
        }
    }

    abstract class CellValidator {
        private String _message = null;

        CellValidator() {
        }

        public abstract boolean isValid(String var1);

        public void setMessage(String message) {
            this._message = message;
        }

        public String getMessage() {
            return this._message;
        }
    }

    static class StringCellRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setOpaque(true);
            this.setText((String)value);
            if (!table.isCellEditable(row, col)) {
                this.setBackground(LocatableNodeController.CLASS_ELEMENT_HIGHLIGHT_COLOR);
            } else {
                this.setBackground(Color.white);
            }
            return this;
        }
    }

    static class PortBooleanCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == Boolean.TRUE) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            this.setHorizontalAlignment(0);
            if (!table.isCellEditable(row, col)) {
                this.setBackground(LocatableNodeController.CLASS_ELEMENT_HIGHLIGHT_COLOR);
            } else {
                this.setBackground(Color.white);
            }
            return this;
        }
    }

    class PortTableModel
    extends AbstractTableModel {
        public PortTableModel(List portList) {
            Iterator ports = portList.iterator();
            PortConfigurerDialog.this._ports = new Vector();
            while (ports.hasNext()) {
                Port p = (Port)ports.next();
                Hashtable<String, Object> portInfo = new Hashtable<String, Object>();
                if (PortConfigurerDialog.this._columnNames.contains("Name")) {
                    portInfo.put("Name", p.getName());
                }
                if (PortConfigurerDialog.this._columnNames.contains("Direction")) {
                    StringAttribute _cardinal = (StringAttribute)p.getAttribute("_cardinal");
                    String _direction = _cardinal != null ? _cardinal.getExpression().toUpperCase() : "DEFAULT";
                    portInfo.put("Direction", _direction);
                }
                if (PortConfigurerDialog.this._columnNames.contains("Show Name")) {
                    boolean isShowSet = PortConfigurerDialog.this._isPropertySet(p, "_showName");
                    if (isShowSet) {
                        portInfo.put("Show Name", Boolean.TRUE);
                    } else {
                        portInfo.put("Show Name", Boolean.FALSE);
                    }
                }
                if (PortConfigurerDialog.this._columnNames.contains("Hide")) {
                    boolean isHideSet = PortConfigurerDialog.this._isPropertySet(p, "_hide");
                    if (isHideSet) {
                        portInfo.put("Hide", Boolean.TRUE);
                    } else {
                        portInfo.put("Hide", Boolean.FALSE);
                    }
                }
                if (p instanceof IOPort) {
                    IOPort iop = (IOPort)p;
                    if (PortConfigurerDialog.this._columnNames.contains("Input")) {
                        portInfo.put("Input", iop.isInput());
                    }
                    if (PortConfigurerDialog.this._columnNames.contains("Output")) {
                        portInfo.put("Output", iop.isOutput());
                    }
                    if (PortConfigurerDialog.this._columnNames.contains("Multiport")) {
                        portInfo.put("Multiport", iop.isMultiport());
                    }
                }
                if (p instanceof TypedIOPort) {
                    TypedIOPort tiop = (TypedIOPort)p;
                    if (PortConfigurerDialog.this._columnNames.contains("Type")) {
                        TypeAttribute _type = (TypeAttribute)tiop.getAttribute("_type");
                        if (_type != null) {
                            portInfo.put("Type", _type.getExpression());
                        } else {
                            portInfo.put("Type", "");
                        }
                    }
                }
                if (PortConfigurerDialog.this._columnNames.contains("Units")) {
                    String units = "";
                    UnitAttribute _unitsAttribute = (UnitAttribute)p.getAttribute("_units");
                    if (_unitsAttribute != null) {
                        units = _unitsAttribute.getExpression();
                        if (units != null) {
                            portInfo.put("Units", units);
                        } else {
                            portInfo.put("Units", "");
                        }
                    } else {
                        portInfo.put("Units", "");
                    }
                }
                portInfo.put("9", p);
                PortConfigurerDialog.this._ports.add(portInfo);
            }
        }

        public void addNewPort() {
            Hashtable<String, Object> portInfo = new Hashtable<String, Object>();
            if (PortConfigurerDialog.this._columnNames.contains("Name")) {
                portInfo.put("Name", "");
            }
            if (PortConfigurerDialog.this._columnNames.contains("Direction")) {
                portInfo.put("Direction", "DEFAULT");
            }
            if (PortConfigurerDialog.this._columnNames.contains("Show Name")) {
                portInfo.put("Show Name", Boolean.FALSE);
            }
            if (PortConfigurerDialog.this._columnNames.contains("Hide")) {
                portInfo.put("Hide", Boolean.FALSE);
            }
            if (PortConfigurerDialog.this._columnNames.contains("Input")) {
                portInfo.put("Input", Boolean.FALSE);
            }
            if (PortConfigurerDialog.this._columnNames.contains("Output")) {
                portInfo.put("Output", Boolean.FALSE);
            }
            if (PortConfigurerDialog.this._columnNames.contains("Multiport")) {
                portInfo.put("Multiport", Boolean.FALSE);
            }
            if (PortConfigurerDialog.this._columnNames.contains("Type")) {
                portInfo.put("Type", "");
            }
            if (PortConfigurerDialog.this._columnNames.contains("Units")) {
                portInfo.put("Units", "");
            }
            PortConfigurerDialog.this._ports.add(portInfo);
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public void removePort() {
            PortConfigurerDialog.this._ports.remove(PortConfigurerDialog.this._selectedRow);
            this.fireTableRowsDeleted(PortConfigurerDialog.this._selectedRow, PortConfigurerDialog.this._selectedRow);
            PortConfigurerDialog.this._enableApplyButton(true);
            PortConfigurerDialog.this._setDirty(true);
        }

        @Override
        public int getColumnCount() {
            return PortConfigurerDialog.this._columnNames.size();
        }

        @Override
        public int getRowCount() {
            return PortConfigurerDialog.this._ports.size();
        }

        @Override
        public String getColumnName(int col) {
            return (String)PortConfigurerDialog.this._columnNames.get(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            Hashtable portInfo = (Hashtable)PortConfigurerDialog.this._ports.elementAt(row);
            return portInfo.get(this.getColumnName(col));
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Hashtable portInfo = (Hashtable)PortConfigurerDialog.this._ports.elementAt(row);
            portInfo.put(this.getColumnName(col), value);
            PortConfigurerDialog.this._enableApplyButton(true);
            PortConfigurerDialog.this._setDirty(true);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Hashtable portInfo = (Hashtable)PortConfigurerDialog.this._ports.elementAt(row);
            Port port = (Port)portInfo.get("9");
            return port == null || port.getDerivedLevel() >= Integer.MAX_VALUE || col != PortConfigurerDialog.this._columnNames.indexOf("Name") && col != PortConfigurerDialog.this._columnNames.indexOf("Input") && col != PortConfigurerDialog.this._columnNames.indexOf("Output") && col != PortConfigurerDialog.this._columnNames.indexOf("Multiport");
        }

        public void toggleShowAllNames() {
            PortConfigurerDialog.this._showAllNames = !PortConfigurerDialog.this._showAllNames;
            Boolean show = PortConfigurerDialog.this._showAllNames;
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(show, i, PortConfigurerDialog.this._columnNames.indexOf("Show Name"));
            }
        }

        public void toggleHidePorts() {
            PortConfigurerDialog.this._hideAllPorts = !PortConfigurerDialog.this._hideAllPorts;
            Boolean _hide = PortConfigurerDialog.this._hideAllPorts;
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(_hide, i, PortConfigurerDialog.this._columnNames.indexOf("Hide"));
            }
        }
    }
}

