/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Color;
import java.awt.Window;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.actor.gui.PasswordAttribute;
import ptolemy.actor.gui.style.ParameterEditorStyle;
import ptolemy.actor.parameters.DoubleRangeParameter;
import ptolemy.actor.parameters.FilePortParameter;
import ptolemy.actor.parameters.IntRangeParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.gui.CloseListener;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.ValueListener;
import ptolemy.moml.Documentation;
import ptolemy.moml.ErrorHandler;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.moml.MoMLParser;
import ptolemy.util.StringUtilities;

public class PtolemyQuery
extends Query
implements QueryListener,
ValueListener,
ChangeListener,
CloseListener {
    private ComponentDialog _dialog;
    private NamedObj _handler;
    private boolean _ignoreChangeNotifications = false;
    private boolean _isOpenErrorWindow = false;
    private Map _attributes = new HashMap();
    private PtolemyQuery _query = null;
    private Map _revertValue = new HashMap();
    private ErrorHandler _savedErrorHandler = null;
    private static Color _STRING_MODE_BACKGROUND_COLOR = new Color(230, 255, 255, 255);
    private Map _varToListOfEntries;

    public PtolemyQuery(NamedObj handler) {
        this.addQueryListener(this);
        this._handler = handler;
        if (this._handler != null) {
            this._handler.addChangeListener(this);
        }
        this._varToListOfEntries = new HashMap();
    }

    public void addStyledEntry(Settable attribute) {
        String defaultValue;
        boolean foundStyle = false;
        if (attribute instanceof NamedObj) {
            Iterator styles = ((NamedObj)((Object)attribute)).attributeList(ParameterEditorStyle.class).iterator();
            while (styles.hasNext() && !foundStyle) {
                ParameterEditorStyle style = (ParameterEditorStyle)styles.next();
                try {
                    style.addEntry(this);
                    foundStyle = true;
                }
                catch (IllegalActionException ex) {}
            }
        }
        if (!foundStyle) {
            String name = attribute.getName();
            String displayName = attribute.getDisplayName();
            try {
                if (attribute.getVisibility() == Settable.NOT_EDITABLE) {
                    String defaultValue2 = attribute.getExpression();
                    this.addDisplay(name, displayName, defaultValue2);
                    this.attachParameter(attribute, name);
                    foundStyle = true;
                } else if (attribute instanceof IntRangeParameter) {
                    int current = ((IntRangeParameter)attribute).getCurrentValue();
                    int min = ((IntRangeParameter)attribute).getMinValue();
                    int max = ((IntRangeParameter)attribute).getMaxValue();
                    this.addSlider(name, displayName, current, min, max);
                    this.attachParameter(attribute, name);
                    foundStyle = true;
                } else if (attribute instanceof DoubleRangeParameter) {
                    double current = ((DoubleToken)((DoubleRangeParameter)attribute).getToken()).doubleValue();
                    double max = ((DoubleToken)((DoubleRangeParameter)attribute).max.getToken()).doubleValue();
                    double min = ((DoubleToken)((DoubleRangeParameter)attribute).min.getToken()).doubleValue();
                    int precision = ((IntToken)((DoubleRangeParameter)attribute).precision.getToken()).intValue();
                    int quantized = (int)Math.round((current - min) * (double)precision / (max - min));
                    this.addSlider(name, displayName, quantized, 0, precision);
                    this.attachParameter(attribute, name);
                    foundStyle = true;
                } else if (attribute instanceof ColorAttribute) {
                    this.addColorChooser(name, displayName, attribute.getExpression());
                    this.attachParameter(attribute, name);
                    foundStyle = true;
                } else if (attribute instanceof FileParameter || attribute instanceof FilePortParameter) {
                    Token value;
                    URI modelURI = URIAttribute.getModelURI((NamedObj)((Object)attribute));
                    File directory = null;
                    if (modelURI != null && modelURI.getScheme().equals("file")) {
                        File modelFile = new File(modelURI);
                        directory = modelFile.getParentFile();
                    }
                    URI base = null;
                    if (directory != null) {
                        base = directory.toURI();
                    }
                    boolean allowFiles = true;
                    boolean allowDirectories = false;
                    Parameter marker = (Parameter)((NamedObj)((Object)attribute)).getAttribute("allowFiles", Parameter.class);
                    if (marker != null && (value = marker.getToken()) instanceof BooleanToken) {
                        allowFiles = ((BooleanToken)value).booleanValue();
                    }
                    if ((marker = (Parameter)((NamedObj)((Object)attribute)).getAttribute("allowDirectories", Parameter.class)) != null && (value = marker.getToken()) instanceof BooleanToken) {
                        allowDirectories = ((BooleanToken)value).booleanValue();
                    }
                    if (!allowFiles && !allowDirectories) {
                        return;
                    }
                    this.addFileChooser(name, displayName, attribute.getExpression(), base, directory, allowFiles, allowDirectories, PtolemyQuery.preferredBackgroundColor(attribute), PtolemyQuery.preferredForegroundColor(attribute));
                    this.attachParameter(attribute, name);
                    foundStyle = true;
                } else if (attribute instanceof PasswordAttribute) {
                    this.addPassword(name, displayName, "");
                    this.attachParameter(attribute, name);
                    foundStyle = true;
                } else if (attribute instanceof Parameter && ((Parameter)attribute).getChoices() != null) {
                    Parameter castAttribute = (Parameter)attribute;
                    this.addChoice(name, displayName, castAttribute.getChoices(), castAttribute.getExpression(), true, PtolemyQuery.preferredBackgroundColor(attribute), PtolemyQuery.preferredForegroundColor(attribute));
                    this.attachParameter(attribute, name);
                    foundStyle = true;
                } else if (attribute instanceof NamedObj && (((NamedObj)((Object)attribute)).getAttribute("_textWidthHint") != null || ((NamedObj)((Object)attribute)).getAttribute("_textHeightHint") != null)) {
                    Token token;
                    Attribute heightAttribute;
                    Token token2;
                    int widthValue = 30;
                    int heightValue = 10;
                    Attribute widthAttribute = ((NamedObj)((Object)attribute)).getAttribute("_textWidthHint");
                    if (widthAttribute instanceof Variable && (token2 = ((Variable)widthAttribute).getToken()) instanceof IntToken) {
                        widthValue = ((IntToken)token2).intValue();
                    }
                    if ((heightAttribute = ((NamedObj)((Object)attribute)).getAttribute("_textHeightHint")) instanceof Variable && (token = ((Variable)heightAttribute).getToken()) instanceof IntToken) {
                        heightValue = ((IntToken)token).intValue();
                    }
                    this.addTextArea(name, displayName, attribute.getExpression(), PtolemyQuery.preferredBackgroundColor(attribute), PtolemyQuery.preferredForegroundColor(attribute), heightValue, widthValue);
                    this.attachParameter(attribute, name);
                    foundStyle = true;
                } else if (attribute instanceof Variable) {
                    Type declaredType = ((Variable)attribute).getDeclaredType();
                    Token current = ((Variable)attribute).getToken();
                    if (declaredType == BaseType.BOOLEAN && (attribute.getExpression().equals("true") || attribute.getExpression().equals("false"))) {
                        this.addCheckBox(name, displayName, ((BooleanToken)current).booleanValue());
                        this.attachParameter(attribute, name);
                        foundStyle = true;
                    }
                }
            }
            catch (IllegalActionException ex) {
                // empty catch block
            }
        }
        if ((defaultValue = attribute.getExpression()) == null) {
            defaultValue = "";
        }
        if (!foundStyle) {
            this.addLine(attribute.getName(), attribute.getDisplayName(), defaultValue, PtolemyQuery.preferredBackgroundColor(attribute), PtolemyQuery.preferredForegroundColor(attribute));
            this.attachParameter(attribute, attribute.getName());
        }
    }

    public void attachParameter(Settable attribute, String entryName) {
        List<String> entryNameList;
        this._attributes.put(entryName, attribute);
        this._revertValue.put(entryName, this._getTranslatedExpression(attribute));
        attribute.addValueListener(this);
        if (this._varToListOfEntries.get(attribute) == null) {
            entryNameList = new LinkedList<String>();
            entryNameList.add(entryName);
            this._varToListOfEntries.put(attribute, entryNameList);
        } else {
            entryNameList = (List)this._varToListOfEntries.get(attribute);
            Iterator entryNames = entryNameList.iterator();
            boolean found = false;
            while (entryNames.hasNext()) {
                String name = (String)entryNames.next();
                if (!name.equals(entryName)) continue;
                found = true;
            }
            if (!found) {
                entryNameList.add(entryName);
            }
        }
        if (attribute instanceof NamedObj) {
            Attribute tooltipAttribute = ((NamedObj)((Object)attribute)).getAttribute("tooltip");
            if (tooltipAttribute != null && tooltipAttribute instanceof Documentation) {
                this.setToolTip(entryName, ((Documentation)tooltipAttribute).getValueAsString());
            } else {
                String tip = Documentation.consolidate((NamedObj)((Object)attribute));
                if (tip != null) {
                    this.setToolTip(entryName, tip);
                }
            }
        }
    }

    @Override
    public void changeExecuted(ChangeRequest change) {
        if (change != null) {
            String name;
            if (change.getSource() != this) {
                return;
            }
            if (this._savedErrorHandler != null) {
                MoMLParser.setErrorHandler(this._savedErrorHandler);
            }
            if (this._attributes.containsKey(name = change.getDescription())) {
                Settable attribute = (Settable)this._attributes.get(name);
                this._revertValue.put(name, this._getTranslatedExpression(attribute));
            }
        }
    }

    @Override
    public void changeFailed(final ChangeRequest change, Exception exception) {
        if (change == null || change.getSource() != this) {
            return;
        }
        if (this._savedErrorHandler != null) {
            MoMLParser.setErrorHandler(this._savedErrorHandler);
        }
        if (this._isOpenErrorWindow) {
            this.setMessage(exception.getMessage() + "\n\nPlease enter a new value (or cancel to revert):");
        } else {
            int nextQuote;
            if (change.isErrorReported()) {
                return;
            }
            change.setErrorReported(true);
            this._query = new PtolemyQuery(this._handler);
            this._query.setTextWidth(this.getTextWidth());
            this._query._isOpenErrorWindow = true;
            String description = change.getDescription();
            this._query.setMessage(exception.getMessage() + "\n\nPlease enter a new value:");
            String tmpEntryName = description;
            int patternStart = description.lastIndexOf("<property name=\"");
            if (patternStart >= 0 && (nextQuote = description.indexOf("\"", patternStart + 16)) > patternStart + 15) {
                tmpEntryName = description.substring(patternStart + 16, nextQuote);
            }
            final String entryName = tmpEntryName;
            final Settable attribute = (Settable)this._attributes.get(entryName);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (attribute == null) {
                        throw new InternalErrorException("Expected attribute attached to entry name: " + entryName);
                    }
                    PtolemyQuery.this._query.addStyledEntry(attribute);
                    PtolemyQuery.this._dialog = new ComponentDialog(JOptionPane.getFrameForComponent(PtolemyQuery.this), "Error", PtolemyQuery.this._query, null);
                    PtolemyQuery.this._query._isOpenErrorWindow = false;
                    if (PtolemyQuery.this._dialog.buttonPressed().equals("Cancel")) {
                        if (PtolemyQuery.this._revertValue.containsKey(entryName)) {
                            String revertValue = (String)PtolemyQuery.this._revertValue.get(entryName);
                            PtolemyQuery.this.set(((NamedObj)((Object)attribute)).getName(), revertValue);
                            PtolemyQuery.this.changed(entryName);
                        }
                    } else {
                        try {
                            attribute.validate();
                        }
                        catch (IllegalActionException ex) {
                            change.setErrorReported(false);
                            PtolemyQuery.this.changeFailed(change, ex);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void changed(final String name) {
        if (this._attributes.containsKey(name)) {
            ChangeRequest request;
            final Settable attribute = (Settable)this._attributes.get(name);
            if (attribute == null) {
                return;
            }
            if (attribute instanceof PasswordAttribute) {
                request = new ChangeRequest(this, name){

                    @Override
                    protected void _execute() throws IllegalActionException {
                        char[] password = PtolemyQuery.this.getCharArrayValue(name);
                        ((PasswordAttribute)attribute).setPassword(password);
                        attribute.validate();
                        for (PasswordAttribute derivedPassword : ((PasswordAttribute)attribute).getDerivedList()) {
                            derivedPassword.setPassword(password);
                        }
                    }
                };
            } else if (attribute instanceof NamedObj) {
                NamedObj castAttribute = (NamedObj)((Object)attribute);
                String stringValue = this.getStringValue(name);
                if (attribute instanceof DoubleRangeParameter) {
                    try {
                        int newValue = Integer.parseInt(stringValue);
                        int precision = ((IntToken)((DoubleRangeParameter)attribute).precision.getToken()).intValue();
                        double max = ((DoubleToken)((DoubleRangeParameter)attribute).max.getToken()).doubleValue();
                        double min = ((DoubleToken)((DoubleRangeParameter)attribute).min.getToken()).doubleValue();
                        double newValueAsDouble = min + (max - min) * (double)newValue / (double)precision;
                        stringValue = "" + newValueAsDouble;
                    }
                    catch (IllegalActionException e) {
                        throw new InternalErrorException(e);
                    }
                }
                NamedObj parent = castAttribute.getContainer();
                String moml = "<property name=\"" + castAttribute.getName() + "\" value=\"" + StringUtilities.escapeForXML(stringValue) + "\"/>";
                request = new MoMLChangeRequest(this, parent, moml, null){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void _execute() throws Exception {
                        PtolemyQuery ptolemyQuery = PtolemyQuery.this;
                        synchronized (ptolemyQuery) {
                            try {
                                PtolemyQuery.this._ignoreChangeNotifications = true;
                                super._execute();
                            }
                            finally {
                                PtolemyQuery.this._ignoreChangeNotifications = false;
                            }
                        }
                    }
                };
            } else {
                request = new ChangeRequest(this, name){

                    @Override
                    protected void _execute() throws IllegalActionException {
                        attribute.setExpression(PtolemyQuery.this.getStringValue(name));
                        attribute.validate();
                    }
                };
            }
            request.addChangeListener(this);
            if (this._handler == null) {
                request.execute();
            } else {
                if (request instanceof MoMLChangeRequest) {
                    ((MoMLChangeRequest)request).setUndoable(true);
                }
                this._savedErrorHandler = MoMLParser.getErrorHandler();
                MoMLParser.setErrorHandler(null);
                this._handler.requestChange(request);
            }
        }
    }

    public static Color preferredBackgroundColor(Object object) {
        Color background = Color.white;
        if (object instanceof Parameter && ((Parameter)object).isStringMode()) {
            background = _STRING_MODE_BACKGROUND_COLOR;
        }
        return background;
    }

    public static Color preferredForegroundColor(Object object) {
        Color foreground = Color.black;
        return foreground;
    }

    @Override
    public void valueChanged(final Settable attribute) {
        if (this._ignoreChangeNotifications) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PtolemyQuery.this._attributes.containsValue(attribute)) {
                    List entryNameList = (List)PtolemyQuery.this._varToListOfEntries.get(attribute);
                    Iterator entryNames = entryNameList.iterator();
                    String newValue = PtolemyQuery.this._getTranslatedExpression(attribute);
                    while (entryNames.hasNext()) {
                        String name = (String)entryNames.next();
                        if (PtolemyQuery.this.getStringValue(name).equals(newValue)) continue;
                        PtolemyQuery.this.set(name, newValue);
                    }
                }
            }
        });
    }

    @Override
    public void windowClosed(Window window, String button) {
        this._handler.removeChangeListener(this);
        this.removeQueryListener(this);
        for (Settable attribute : this._attributes.values()) {
            attribute.removeValueListener(this);
        }
    }

    private String _getTranslatedExpression(Settable attribute) {
        String newValue = attribute.getExpression();
        if (attribute instanceof DoubleRangeParameter) {
            try {
                double current = Double.parseDouble(newValue);
                double max = ((DoubleToken)((DoubleRangeParameter)attribute).max.getToken()).doubleValue();
                double min = ((DoubleToken)((DoubleRangeParameter)attribute).min.getToken()).doubleValue();
                int precision = ((IntToken)((DoubleRangeParameter)attribute).precision.getToken()).intValue();
                int quantized = (int)Math.round((current - min) * (double)precision / (max - min));
                newValue = "" + quantized;
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException(e);
            }
        }
        return newValue;
    }
}

