/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.BooleanToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class Accumulator
extends Transformer {
    public Parameter lowerBound;
    public Parameter init;
    public TypedIOPort reset;
    public Parameter upperBound;
    private Token _sum;
    private Token _latestSum;

    public Accumulator(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setMultiport(true);
        this.reset = new TypedIOPort(this, "reset", true, false);
        this.reset.setTypeEquals(BaseType.BOOLEAN);
        this.reset.setMultiport(true);
        this.init = new Parameter(this, "init");
        this.init.setExpression("0");
        this.lowerBound = new Parameter(this, "lowerBound");
        this.lowerBound.setTypeSameAs(this.init);
        this.upperBound = new Parameter(this, "upperBound");
        this.upperBound.setTypeSameAs(this.init);
        this.output.setTypeAtLeast(this.init);
        this.output.setTypeAtLeast(this.input);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Accumulator newObject = (Accumulator)super.clone(workspace);
        newObject.lowerBound.setTypeSameAs(newObject.init);
        newObject.upperBound.setTypeSameAs(newObject.init);
        newObject.output.setTypeAtLeast(newObject.init);
        newObject.output.setTypeAtLeast(newObject.input);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        Token upperBoundValue;
        int i;
        super.fire();
        this._latestSum = this._sum;
        for (i = 0; i < this.reset.getWidth(); ++i) {
            BooleanToken r;
            if (!this.reset.hasToken(i) || !(r = (BooleanToken)this.reset.get(i)).booleanValue()) continue;
            this._latestSum = this.output.getType().convert(this.init.getToken());
        }
        for (i = 0; i < this.input.getWidth(); ++i) {
            if (!this.input.hasToken(i)) continue;
            Token in = this.input.get(i);
            this._latestSum = this._latestSum.add(in);
        }
        Token lowerBoundValue = this.lowerBound.getToken();
        if (lowerBoundValue != null) {
            if (lowerBoundValue instanceof ScalarToken) {
                if (((ScalarToken)lowerBoundValue).isGreaterThan((ScalarToken)this._latestSum).booleanValue()) {
                    this._latestSum = lowerBoundValue;
                }
            } else {
                throw new IllegalActionException((Nameable)this, "lowerBound parameter only works with scalar values. Value given was: " + lowerBoundValue);
            }
        }
        if ((upperBoundValue = this.upperBound.getToken()) != null) {
            if (upperBoundValue instanceof ScalarToken) {
                if (((ScalarToken)upperBoundValue).isLessThan((ScalarToken)this._latestSum).booleanValue()) {
                    this._latestSum = upperBoundValue;
                }
            } else {
                throw new IllegalActionException((Nameable)this, "upperBound parameter only works with scalar values. Value given was: " + upperBoundValue);
            }
        }
        this.output.broadcast(this._latestSum);
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._latestSum = this._sum = this.output.getType().convert(this.init.getToken());
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._sum = this._latestSum;
        return super.postfire();
    }
}

