/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class ArrayAppend
extends Transformer {
    public ArrayAppend(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setMultiport(true);
        this.input.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.output.setTypeAtLeast(this.input);
        this.output.setTypeAtLeast(ArrayType.ARRAY_UNSIZED_BOTTOM);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArrayAppend newObject = (ArrayAppend)super.clone(workspace);
        newObject.input.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        newObject.output.setTypeAtLeast(newObject.input);
        newObject.output.setTypeAtLeast(ArrayType.ARRAY_UNSIZED_BOTTOM);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int width = this.input.getWidth();
        if (width == 0) {
            throw new IllegalActionException((Nameable)this, "No input channels.");
        }
        int outputWidth = 0;
        Token[][] inputs = new Token[width][];
        for (int i = 0; i < width; ++i) {
            if (!this.input.hasToken(i)) continue;
            ArrayToken token = (ArrayToken)this.input.get(i);
            inputs[i] = token.arrayValue();
            outputWidth += inputs[i].length;
        }
        Token[] array = new Token[outputWidth];
        int runningPosition = 0;
        for (int i = 0; i < width; ++i) {
            System.arraycopy(inputs[i], 0, array, runningPosition, inputs[i].length);
            runningPosition += inputs[i].length;
        }
        Type elementType = ((ArrayType)this.input.getType()).getElementType();
        this.output.send(0, new ArrayToken(elementType, array));
    }
}

