/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class ArrayMinimum
extends Transformer {
    public TypedIOPort index = new TypedIOPort(this, "index", false, true);

    public ArrayMinimum(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.index.setTypeEquals(BaseType.INT);
        this.output.setTypeAtLeast(ArrayType.elementType(this.input));
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArrayMinimum newObject = (ArrayMinimum)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.input));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int indexValue = 0;
        if (this.input.hasToken(0)) {
            ArrayToken token = (ArrayToken)this.input.get(0);
            ScalarToken currentMin = (ScalarToken)token.getElement(indexValue);
            ScalarToken temp = null;
            for (int i = indexValue + 1; i < token.length(); ++i) {
                temp = (ScalarToken)token.getElement(i);
                if (!currentMin.isGreaterThan(temp).booleanValue()) continue;
                indexValue = i;
                currentMin = temp;
            }
            this.output.send(0, currentMin);
            this.index.broadcast(new IntToken(indexValue));
        }
    }
}

