/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.ArrayList;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.UtilityFunctions;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class ArraySort
extends Transformer {
    public Parameter allowDuplicates;
    public Parameter ascending;

    public ArraySort(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.output.setTypeAtLeast(this.input);
        this.output.setTypeAtLeast(ArrayType.ARRAY_UNSIZED_BOTTOM);
        this.allowDuplicates = new Parameter(this, "allowDuplicates");
        this.allowDuplicates.setExpression("true");
        this.allowDuplicates.setTypeEquals(BaseType.BOOLEAN);
        this.ascending = new Parameter(this, "ascending");
        this.ascending.setExpression("true");
        this.ascending.setTypeEquals(BaseType.BOOLEAN);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArraySort newObject = (ArraySort)super.clone(workspace);
        newObject.input.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        newObject.output.setTypeAtLeast(newObject.input);
        newObject.output.setTypeAtLeast(ArrayType.ARRAY_UNSIZED_BOTTOM);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            ArrayToken token = (ArrayToken)this.input.get(0);
            Type inputElementType = token.getElementType();
            if (token.length() == 0) {
                this.output.send(0, token);
                return;
            }
            boolean ascendingValue = ((BooleanToken)this.ascending.getToken()).booleanValue();
            ArrayToken result = null;
            try {
                result = ascendingValue ? UtilityFunctions.sort(token) : UtilityFunctions.sortDescending(token);
            }
            catch (ClassCastException ex) {
                throw new IllegalActionException((Nameable)this, ex.getMessage());
            }
            boolean allowDuplicatesValue = ((BooleanToken)this.allowDuplicates.getToken()).booleanValue();
            if (!allowDuplicatesValue) {
                ArrayList<Token> list = new ArrayList<Token>();
                Token previous = result.getElement(0);
                list.add(previous);
                for (int i = 1; i < result.length(); ++i) {
                    Token next = result.getElement(i);
                    if (next.isEqualTo(previous).booleanValue()) continue;
                    list.add(next);
                    previous = next;
                }
                Token[] dummy = new Token[]{};
                result = new ArrayToken(inputElementType, list.toArray(dummy));
            }
            this.output.send(0, result);
        }
    }
}

