/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.Iterator;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class BusDisassembler
extends TypedAtomicActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);

    public BusDisassembler(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setMultiport(true);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"0\" y=\"0\" width=\"6\" height=\"40\" style=\"fill:black\"/>\n</svg>\n");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int inputWidth = this.input.getWidth();
        Iterator outputPorts = this.outputPortList().iterator();
        TypedIOPort outputPort = outputPorts.hasNext() ? outputPorts.next() : null;
        int outputWidth = outputPort != null ? outputPort.getWidth() : 0;
        int j = 0;
        for (int i = 0; i < inputWidth; ++i) {
            if (this.input.hasToken(i)) {
                Token t = this.input.get(i);
                if (outputPort != null) {
                    outputPort.send(j, t);
                }
            }
            if (outputPort == null) continue;
            if (j < outputWidth - 1) {
                ++j;
                continue;
            }
            outputPort = outputPorts.hasNext() ? outputPorts.next() : null;
            outputWidth = outputPort != null ? outputPort.getWidth() : 0;
            j = 0;
        }
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        if (this.inputPortList().size() > 1) {
            throw new IllegalActionException((Nameable)this, "can have only one input port.");
        }
    }
}

