/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.RandomSource;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;
import ptolemy.math.SignalProcessing;

public class DiscreteRandomSource
extends RandomSource {
    public Parameter pmf = new Parameter(this, "pmf");
    public Parameter values;
    private Token _current;
    private transient double[] _pmf;

    public DiscreteRandomSource(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.pmf.setExpression("{0.5, 0.5}");
        this.pmf.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.values = new Parameter(this, "values");
        this.values.setExpression("{0, 1}");
        this.output.setTypeAtLeast(ArrayType.elementType(this.values));
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.pmf) {
            ArrayToken pmfValue = (ArrayToken)this.pmf.getToken();
            this._pmf = new double[pmfValue.length()];
            double sum = 0.0;
            for (int i = 0; i < this._pmf.length; ++i) {
                this._pmf[i] = ((DoubleToken)pmfValue.getElement(i)).doubleValue();
                sum += this._pmf[i];
            }
            if (!SignalProcessing.close(sum, 1.0)) {
                throw new IllegalActionException((Nameable)this, "Parameter values are required to sum to one.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        DiscreteRandomSource newObject = (DiscreteRandomSource)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.values));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.output.send(0, this._current);
    }

    @Override
    protected void _generateRandomNumber() throws IllegalActionException {
        double randomValue = this._random.nextDouble();
        ArrayToken valuesToken = (ArrayToken)this.values.getToken();
        if (this._pmf.length != valuesToken.length()) {
            throw new IllegalActionException((Nameable)this, "Parameters values and pmf are required to be arrays with the same length.");
        }
        double cdf = 0.0;
        for (int i = 0; i < this._pmf.length; ++i) {
            if (!(randomValue <= (cdf += this._pmf[i]))) continue;
            this._current = valuesToken.getElement(i);
            return;
        }
        this._current = valuesToken.getElement(this._pmf.length - 1);
    }
}

