/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.io.IOException;
import java.util.StringTokenizer;
import ptolemy.actor.lib.URLReader;
import ptolemy.data.DoubleToken;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class DoubleReader
extends URLReader {
    private double[] _data;
    private int _dataSize;

    public DoubleReader(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        for (int i = 0; i < this._dataSize; ++i) {
            this.output.send(i, new DoubleToken(this._data[i]));
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._dataSize = this.output.getWidth();
        this._data = new double[this._dataSize];
        this.attributeChanged(this.sourceURL);
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        try {
            String oneRow;
            this._dataSize = this.output.getWidth();
            if (this._data.length != this._dataSize) {
                this._data = new double[this._dataSize];
            }
            if ((oneRow = this._reader.readLine()) == null) {
                return false;
            }
            StringTokenizer tokenizer = new StringTokenizer(oneRow);
            int columnCount = tokenizer.countTokens();
            if (this._dataSize > columnCount) {
                this._dataSize = columnCount;
            }
            for (int i = 0; i < this._dataSize; ++i) {
                this._data[i] = Double.valueOf(tokenizer.nextToken());
            }
            return super.prefire();
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "prefire() failed");
        }
    }
}

