/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.RandomSource;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.DoubleToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class Gaussian
extends RandomSource {
    public PortParameter mean;
    public PortParameter standardDeviation;
    private double _current;

    public Gaussian(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.mean = new PortParameter((NamedObj)this, "mean", new DoubleToken(0.0));
        this.mean.setTypeEquals(BaseType.DOUBLE);
        this.standardDeviation = new PortParameter(this, "standardDeviation");
        this.standardDeviation.setExpression("1.0");
        this.standardDeviation.setTypeEquals(BaseType.DOUBLE);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.mean.update();
        this.standardDeviation.update();
        this.output.send(0, new DoubleToken(this._current));
    }

    @Override
    protected void _generateRandomNumber() throws IllegalActionException {
        double meanValue = ((DoubleToken)this.mean.getToken()).doubleValue();
        double standardDeviationValue = ((DoubleToken)this.standardDeviation.getToken()).doubleValue();
        double rawNum = this._random.nextGaussian();
        this._current = rawNum * standardDeviationValue + meanValue;
    }
}

